/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.PollEnricher;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.RouteContext;

public class PollEnrichReifier
extends ProcessorReifier<PollEnrichDefinition> {
    public PollEnrichReifier(RouteContext routeContext, ProcessorDefinition<?> definition) {
        super(routeContext, (PollEnrichDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        long time = ((PollEnrichDefinition)this.definition).getTimeout() != null ? this.parseLong(((PollEnrichDefinition)this.definition).getTimeout()) : -1L;
        boolean isIgnoreInvalidEndpoint = this.parseBoolean(((PollEnrichDefinition)this.definition).getIgnoreInvalidEndpoint(), false);
        Expression exp = this.createExpression(((PollEnrichDefinition)this.definition).getExpression());
        PollEnricher enricher = new PollEnricher(exp, time);
        AggregationStrategy strategy = this.createAggregationStrategy();
        if (strategy == null) {
            enricher.setDefaultAggregationStrategy();
        } else {
            enricher.setAggregationStrategy(strategy);
        }
        if (((PollEnrichDefinition)this.definition).getAggregateOnException() != null) {
            enricher.setAggregateOnException(this.parseBoolean(((PollEnrichDefinition)this.definition).getAggregateOnException(), false));
        }
        if (((PollEnrichDefinition)this.definition).getCacheSize() != null) {
            enricher.setCacheSize(this.parseInt(((PollEnrichDefinition)this.definition).getCacheSize()).intValue());
        }
        enricher.setIgnoreInvalidEndpoint(isIgnoreInvalidEndpoint);
        return enricher;
    }

    private AggregationStrategy createAggregationStrategy() {
        AggregationStrategy strategy = ((PollEnrichDefinition)this.definition).getAggregationStrategy();
        if (strategy == null && ((PollEnrichDefinition)this.definition).getAggregationStrategyRef() != null) {
            Object aggStrategy = this.routeContext.lookup(this.parseString(((PollEnrichDefinition)this.definition).getAggregationStrategyRef()), Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, this.parseString(((PollEnrichDefinition)this.definition).getAggregationStrategyMethodName()));
                if (((PollEnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.parseBoolean(((PollEnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull(), false));
                    adapter.setAllowNullOldExchange(this.parseBoolean(((PollEnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull(), false));
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((PollEnrichDefinition)this.definition).getAggregationStrategyRef());
            }
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)strategy).setCamelContext(this.camelContext);
        }
        return strategy;
    }
}

