/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weka;

import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class WekaConfiguration {
    @UriPath(description="The command to use.", enums="filter,model,read,write,push,pop,version")
    @Metadata(required=true)
    private Command command;
    @UriParam(description="An in/out path for the read/write commands", label="read,write")
    private String path;
    @UriParam(description="The filter spec (i.e. Name [Options])", label="filter")
    private String apply;
    @UriParam(description="The classifier spec (i.e. Name [Options])", label="model")
    private String build;
    @UriParam(description="Flag on whether to use cross-validation with the current dataset", label="model")
    private boolean xval;
    @UriParam(description="The named dataset to train the classifier with", label="model")
    private String dsname;
    @UriParam(description="Number of folds to use for cross-validation", label="model", defaultValue="10")
    private int folds = 10;
    @UriParam(description="An optional seed for the randomizer", label="model", defaultValue="1")
    private int seed = 1;
    @UriParam(description="Path to save the model to", label="model")
    private String saveTo;
    @UriParam(description="Path to load the model from", label="model")
    private String loadFrom;

    Command getCommand() {
        return this.command;
    }

    void setCommand(Command command) {
        this.command = command;
    }

    String getApply() {
        return this.apply;
    }

    void setApply(String apply) {
        this.apply = apply;
    }

    String getBuild() {
        return this.build;
    }

    void setBuild(String build) {
        this.build = build;
    }

    String getPath() {
        return this.path;
    }

    void setPath(String path) {
        this.path = path;
    }

    boolean isXval() {
        return this.xval;
    }

    void setXval(boolean xval) {
        this.xval = xval;
    }

    int getFolds() {
        return this.folds;
    }

    void setFolds(int folds) {
        this.folds = folds;
    }

    int getSeed() {
        return this.seed;
    }

    void setSeed(int seed) {
        this.seed = seed;
    }

    String getSaveTo() {
        return this.saveTo;
    }

    void setSaveTo(String saveTo) {
        this.saveTo = saveTo;
    }

    String getLoadFrom() {
        return this.loadFrom;
    }

    void setLoadFrom(String loadFrom) {
        this.loadFrom = loadFrom;
    }

    String getDsname() {
        return this.dsname;
    }

    void setDsname(String dsname) {
        this.dsname = dsname;
    }

    public static enum Command {
        filter,
        model,
        read,
        write,
        push,
        pop,
        version;

    }
}

