/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weka.core.pmml.Array;
import weka.core.pmml.FieldRef;

public class VectorInstance
implements Serializable {
    private static final long serialVersionUID = -7543200367512646290L;
    protected String m_ID;
    protected Array m_values;
    protected List<FieldRef> m_vectorFields;

    public VectorInstance(Array values, List<FieldRef> vectorFields) {
        this.m_values = values;
        this.m_vectorFields = vectorFields;
    }

    public VectorInstance(Element vecElement, List<FieldRef> vectorFields) throws Exception {
        this.m_vectorFields = vectorFields;
        String id = vecElement.getAttribute("id");
        if (id == null || id.length() == 0) {
            throw new Exception("[VectorInstance] no ID attribute defined!");
        }
        this.m_ID = id;
        NodeList s_arrL = vecElement.getElementsByTagName("REAL-SparseArray");
        NodeList d_arrL = vecElement.getElementsByTagName("REAL-ARRAY");
        if (s_arrL.getLength() == 0 && d_arrL.getLength() == 0) {
            throw new Exception("[VectorInstance] no arrays defined!");
        }
        NodeList arrL = s_arrL.getLength() > 0 ? s_arrL : d_arrL;
        Element theArray = (Element)arrL.item(0);
        this.m_values = Array.create(theArray);
    }

    public String getID() {
        return this.m_ID;
    }

    public Array getValues() {
        return this.m_values;
    }

    public List<FieldRef> getVectorFields() {
        return this.m_vectorFields;
    }

    public VectorInstance subtract(double[] other) throws Exception {
        ArrayList<Object> diffVals = new ArrayList<Object>();
        for (int i = 0; i < other.length; ++i) {
            double x = this.m_values.valueDouble(i);
            double y = other[i];
            double result = x - y;
            diffVals.add(new Double(result));
        }
        Array newArray = Array.create(diffVals, null);
        return new VectorInstance(newArray, this.m_vectorFields);
    }

    public VectorInstance subtract(VectorInstance other) throws Exception {
        if (this.m_vectorFields.size() != other.getVectorFields().size()) {
            throw new Exception("[VectorInstance.dotProduct] supplied vector instance does not have the same number of vector fields as this vector instance!");
        }
        ArrayList<Object> diffVals = new ArrayList<Object>();
        for (int i = 0; i < this.m_vectorFields.size(); ++i) {
            double x = this.m_values.valueDouble(i);
            double y = other.getValues().valueDouble(i);
            double result = x - y;
            diffVals.add(new Double(result));
        }
        Array newArray = Array.create(diffVals, null);
        return new VectorInstance(newArray, this.m_vectorFields);
    }

    public double dotProduct(VectorInstance other) throws Exception {
        if (this.m_vectorFields.size() != other.getVectorFields().size()) {
            throw new Exception("[VectorInstance.dotProduct] supplied vector instance does not have the same number of vector fields as this vector instance!");
        }
        double result = 0.0;
        Array otherValues = other.getValues();
        int n1 = this.m_values.numValues();
        int n2 = otherValues.numValues();
        int p1 = 0;
        int p2 = 0;
        while (p1 < n1 && p2 < n2) {
            int ind2;
            int ind1 = this.m_values.index(p1);
            if (ind1 == (ind2 = otherValues.index(p2))) {
                result += this.m_values.valueSparseDouble(p1) * otherValues.valueSparseDouble(p2);
                ++p1;
                ++p2;
                continue;
            }
            if (ind1 > ind2) {
                ++p2;
                continue;
            }
            ++p1;
        }
        return result;
    }

    public double dotProduct(double[] other) throws Exception {
        double result = 0.0;
        int n1 = this.m_values.numValues();
        for (int i = 0; i < n1; ++i) {
            int ind1 = this.m_values.index(i);
            result += this.m_values.valueSparseDouble(i) * other[ind1];
        }
        return result;
    }
}

