/*
 * Decompiled with CFR 0.152.
 */
package weka.core.stopwords;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import weka.core.stopwords.AbstractFileBasedStopwords;

public class RegExpFromFile
extends AbstractFileBasedStopwords {
    private static final long serialVersionUID = -722795295494945193L;
    protected List<Pattern> m_Patterns;

    @Override
    public String globalInfo() {
        return "Uses the regular expressions stored in the file for determining whether a word is a stopword (ignored if pointing to a directory). One expression per line.\nMore information on regular expressions:\nhttp://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html";
    }

    @Override
    public String stopwordsTipText() {
        return "The file containing the regular expressions.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Patterns = new ArrayList<Pattern>();
        List<String> patterns = this.read();
        for (String pattern : patterns) {
            this.m_Patterns.add(Pattern.compile(pattern));
        }
    }

    @Override
    protected synchronized boolean is(String word) {
        for (Pattern pattern : this.m_Patterns) {
            if (pattern.matcher(word.trim().toLowerCase()).matches()) {
                if (this.m_Debug) {
                    this.debug(pattern.pattern() + " --> true");
                }
                return true;
            }
            if (!this.m_Debug) continue;
            this.debug(pattern.pattern() + " --> false");
        }
        return false;
    }
}

