/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import weka.core.Instances;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.DataCollector;

public abstract class BaseSimpleDataVisualizer
extends BaseStep
implements DataCollector {
    private static final long serialVersionUID = 4955068920302509451L;
    protected List<Data> m_data = new ArrayList<Data>();

    @Override
    public void stepInit() throws WekaException {
    }

    @Override
    public synchronized void processIncoming(Data data) throws WekaException {
        this.processIncoming(data, true);
    }

    protected synchronized void processIncoming(Data data, boolean notifyFinished) {
        this.getStepManager().processing();
        Instances toPlot = (Instances)data.getPrimaryPayload();
        String name = new SimpleDateFormat("HH:mm:ss.SSS - ").format(new Date());
        String title = name + toPlot.relationName();
        int setNum = data.getPayloadElement("aux_set_num", 1);
        int maxSetNum = data.getPayloadElement("aux_max_set_num", 1);
        title = title + " set " + setNum + " of " + maxSetNum;
        this.getStepManager().logDetailed("Processing " + title);
        data.setPayloadElement("aux_textTitle", title);
        this.m_data.add(data);
        if (notifyFinished) {
            this.getStepManager().finished();
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return Arrays.asList("dataSet", "trainingSet", "testSet");
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return null;
    }

    public List<Data> getDatasets() {
        return this.m_data;
    }

    @Override
    public Object retrieveData() {
        return this.getDatasets();
    }

    @Override
    public void restoreData(Object data) throws WekaException {
        if (!(data instanceof List)) {
            throw new WekaException("Was expecting an instance of a List");
        }
        this.m_data = (List)data;
    }
}

