/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cluster;

import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedStartupListener;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StartupListener;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.cluster.CamelClusterEventListener;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.cluster.CamelClusterView;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.cluster.ClusterServiceHelper;
import org.apache.camel.support.cluster.ClusterServiceSelectors;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReferenceCount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Clustered Route policy")
public final class ClusteredRoutePolicy
extends RoutePolicySupport
implements CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(ClusteredRoutePolicy.class);
    private final AtomicBoolean leader;
    private final Set<Route> startedRoutes;
    private final Set<Route> stoppedRoutes;
    private final ReferenceCount refCount;
    private final CamelClusterEventListener.Leadership leadershipEventListener;
    private final CamelContextStartupListener listener;
    private final AtomicBoolean contextStarted;
    private final String namespace;
    private final CamelClusterService.Selector clusterServiceSelector;
    private CamelClusterService clusterService;
    private CamelClusterView clusterView;
    private volatile boolean clusterViewAddListenerDone;
    private volatile boolean startManagedRoutesEarly;
    private Duration initialDelay;
    private ScheduledExecutorService executorService;
    private CamelContext camelContext;

    private ClusteredRoutePolicy(CamelClusterService clusterService, CamelClusterService.Selector clusterServiceSelector, String namespace) {
        this.namespace = namespace;
        this.clusterService = clusterService;
        this.clusterServiceSelector = clusterServiceSelector;
        ObjectHelper.notNull((Object)namespace, (String)"Namespace");
        this.leadershipEventListener = new CamelClusterLeadershipListener();
        this.stoppedRoutes = new HashSet<Route>();
        this.startedRoutes = new HashSet<Route>();
        this.leader = new AtomicBoolean(false);
        this.contextStarted = new AtomicBoolean(false);
        this.initialDelay = Duration.ofMillis(0L);
        try {
            this.listener = new CamelContextStartupListener();
            this.listener.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.refCount = ReferenceCount.onRelease(() -> {
            if (this.camelContext != null) {
                this.camelContext.getManagementStrategy().removeEventNotifier((EventNotifier)this.listener);
                if (this.executorService != null) {
                    this.camelContext.getExecutorServiceManager().shutdownNow((ExecutorService)this.executorService);
                }
            }
            try {
                if (this.clusterView != null) {
                    this.clusterView.removeEventListener((CamelClusterEventListener)this.leadershipEventListener);
                    this.clusterView.getClusterService().releaseView(this.clusterView);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.setLeader(false);
            }
        });
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        if (this.camelContext == camelContext) {
            return;
        }
        if (this.camelContext != null && this.camelContext != camelContext) {
            throw new IllegalStateException("CamelContext should not be changed: current=" + this.camelContext + ", new=" + camelContext);
        }
        try {
            this.camelContext = camelContext;
            this.camelContext.addStartupListener((StartupListener)this.listener);
            this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)this.listener);
            this.executorService = camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "ClusteredRoutePolicy");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Duration getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(Duration initialDelay) {
        this.initialDelay = initialDelay;
    }

    private ServiceStatus getStatus(Route route) {
        if (this.camelContext != null) {
            ServiceStatus answer = this.camelContext.getRouteController().getRouteStatus(route.getId());
            if (answer == null) {
                answer = ServiceStatus.Stopped;
            }
            return answer;
        }
        return null;
    }

    public void onInit(Route route) {
        super.onInit(route);
        this.refCount.retain();
        if (this.camelContext.isStarted() && this.isLeader()) {
            this.startedRoutes.add(route);
        } else {
            LOG.info("Route managed by {}. Setting route {} AutoStartup flag to false.", ((Object)((Object)this)).getClass(), (Object)route.getId());
            route.setAutoStartup(Boolean.valueOf(false));
            this.stoppedRoutes.add(route);
        }
        this.startManagedRoutes();
    }

    protected void doInit() throws Exception {
        if (this.clusterService == null) {
            this.clusterService = (CamelClusterService)ClusterServiceHelper.lookupService((CamelContext)this.camelContext, (CamelClusterService.Selector)this.clusterServiceSelector).orElseThrow(() -> new IllegalStateException("CamelCluster service not found"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ClusteredRoutePolicy {} is using ClusterService instance {} (id={}, type={})", new Object[]{this, this.clusterService, this.clusterService.getId(), this.clusterService.getClass().getName()});
        }
    }

    public void doStart() throws Exception {
        this.clusterView = this.clusterService.getView(this.namespace);
        if (!this.clusterViewAddListenerDone) {
            this.clusterView.addEventListener((CamelClusterEventListener)this.leadershipEventListener);
            this.clusterViewAddListenerDone = true;
        }
    }

    public void doShutdown() throws Exception {
        this.refCount.release();
    }

    @ManagedAttribute(description="Is this route the master or a slave")
    public boolean isLeader() {
        return this.leader.get();
    }

    private synchronized void setLeader(boolean isLeader) {
        if (isLeader && this.leader.compareAndSet(false, isLeader)) {
            LOG.debug("Leadership taken");
            this.startManagedRoutes();
        } else if (!isLeader && this.leader.getAndSet(isLeader)) {
            LOG.debug("Leadership lost");
            this.stopManagedRoutes();
        }
    }

    private void startManagedRoutes() {
        if (this.isLeader()) {
            this.doStartManagedRoutes();
        } else {
            this.doStopManagedRoutes();
        }
    }

    private void doStartManagedRoutes() {
        if (this.camelContext.isStarting()) {
            LOG.debug("Will defer starting managed routes until camel context is fully started");
            this.startManagedRoutesEarly = true;
            return;
        }
        if (!this.isRunAllowed()) {
            return;
        }
        try {
            for (Route route : this.stoppedRoutes) {
                ServiceStatus status = this.getStatus(route);
                if (status == null || !status.isStartable()) continue;
                LOG.debug("Starting route '{}'", (Object)route.getId());
                this.camelContext.getRouteController().startRoute(route.getId());
                this.startedRoutes.add(route);
            }
            this.stoppedRoutes.removeAll(this.startedRoutes);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void stopManagedRoutes() {
        if (this.isLeader()) {
            this.doStartManagedRoutes();
        } else {
            this.doStopManagedRoutes();
        }
    }

    private void doStopManagedRoutes() {
        if (!this.isRunAllowed()) {
            return;
        }
        try {
            for (Route route : this.startedRoutes) {
                ServiceStatus status = this.getStatus(route);
                if (status == null || !status.isStoppable()) continue;
                LOG.debug("Stopping route '{}'", (Object)route.getId());
                this.stopRoute(route);
                this.stoppedRoutes.add(route);
            }
            this.startedRoutes.removeAll(this.stoppedRoutes);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void onCamelContextStarted() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Apply cluster policy (stopped-routes='{}', started-routes='{}')", (Object)this.stoppedRoutes.stream().map(Route::getId).collect(Collectors.joining(",")), (Object)this.startedRoutes.stream().map(Route::getId).collect(Collectors.joining(",")));
        }
        if (this.clusterView != null && !this.clusterViewAddListenerDone) {
            this.clusterView.addEventListener((CamelClusterEventListener)this.leadershipEventListener);
            this.clusterViewAddListenerDone = true;
        } else {
            this.clusterViewAddListenerDone = false;
        }
        if (this.startManagedRoutesEarly) {
            LOG.debug("CamelContext is now fully started, can now start managed routes eager as we were appointed leader during early startup");
            this.startManagedRoutesEarly = false;
            this.startManagedRoutes();
        }
    }

    public static ClusteredRoutePolicy forNamespace(CamelContext camelContext, CamelClusterService.Selector selector, String namespace) throws Exception {
        ClusteredRoutePolicy policy = new ClusteredRoutePolicy(null, selector, namespace);
        policy.setCamelContext(camelContext);
        return policy;
    }

    public static ClusteredRoutePolicy forNamespace(CamelContext camelContext, String namespace) throws Exception {
        return ClusteredRoutePolicy.forNamespace(camelContext, ClusterServiceSelectors.DEFAULT_SELECTOR, namespace);
    }

    public static ClusteredRoutePolicy forNamespace(CamelClusterService service, String namespace) throws Exception {
        return new ClusteredRoutePolicy(service, ClusterServiceSelectors.DEFAULT_SELECTOR, namespace);
    }

    public static ClusteredRoutePolicy forNamespace(CamelClusterService.Selector selector, String namespace) throws Exception {
        return new ClusteredRoutePolicy(null, selector, namespace);
    }

    public static ClusteredRoutePolicy forNamespace(String namespace) throws Exception {
        return ClusteredRoutePolicy.forNamespace(ClusterServiceSelectors.DEFAULT_SELECTOR, namespace);
    }

    private class CamelContextStartupListener
    extends EventNotifierSupport
    implements ExtendedStartupListener {
        private CamelContextStartupListener() {
        }

        public void notify(CamelEvent event) throws Exception {
            this.onCamelContextStarted();
        }

        public boolean isEnabled(CamelEvent event) {
            return event instanceof CamelEvent.CamelContextStartedEvent;
        }

        public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        }

        public void onCamelContextFullyStarted(CamelContext context, boolean alreadyStarted) throws Exception {
            if (alreadyStarted) {
                this.onCamelContextStarted();
            }
        }

        private void onCamelContextStarted() {
            if (ClusteredRoutePolicy.this.contextStarted.compareAndSet(false, true)) {
                if (ClusteredRoutePolicy.this.initialDelay.toMillis() > 0L) {
                    LOG.debug("Policy will be effective in {}", (Object)ClusteredRoutePolicy.this.initialDelay);
                    ClusteredRoutePolicy.this.executorService.schedule(() -> ClusteredRoutePolicy.this.onCamelContextStarted(), ClusteredRoutePolicy.this.initialDelay.toMillis(), TimeUnit.MILLISECONDS);
                } else {
                    ClusteredRoutePolicy.this.onCamelContextStarted();
                }
            }
        }
    }

    private class CamelClusterLeadershipListener
    implements CamelClusterEventListener.Leadership {
        private CamelClusterLeadershipListener() {
        }

        public void leadershipChanged(CamelClusterView view, Optional<CamelClusterMember> leader) {
            ClusteredRoutePolicy.this.setLeader(ClusteredRoutePolicy.this.clusterView.getLocalMember().isLeader());
        }
    }
}

