/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.util.Random;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.ConditionalEstimator;
import weka.estimators.Estimator;
import weka.estimators.KernelEstimator;

public class KKConditionalEstimator
implements ConditionalEstimator {
    private double[] m_Values;
    private double[] m_CondValues = new double[50];
    private double[] m_Weights;
    private int m_NumValues = 0;
    private double m_SumOfWeights = 0.0;
    private double m_StandardDev = 0.0;
    private boolean m_AllWeightsOne = true;
    private double m_Precision;

    private int findNearestPair(double key, double secondaryKey) {
        int low = 0;
        int high = this.m_NumValues;
        int middle = 0;
        while (low < high) {
            middle = (low + high) / 2;
            double current = this.m_CondValues[middle];
            if (current == key) {
                double secondary = this.m_Values[middle];
                if (secondary == secondaryKey) {
                    return middle;
                }
                if (secondary > secondaryKey) {
                    high = middle;
                } else if (secondary < secondaryKey) {
                    low = middle + 1;
                }
            }
            if (current > key) {
                high = middle;
                continue;
            }
            if (!(current < key)) continue;
            low = middle + 1;
        }
        return low;
    }

    private double round(double data) {
        return Math.rint(data / this.m_Precision) * this.m_Precision;
    }

    public KKConditionalEstimator(double precision) {
        this.m_Values = new double[50];
        this.m_Weights = new double[50];
        this.m_Precision = precision;
    }

    @Override
    public void addValue(double data, double given, double weight) {
        data = this.round(data);
        int insertIndex = this.findNearestPair(given = this.round(given), data);
        if (this.m_NumValues <= insertIndex || this.m_CondValues[insertIndex] != given || this.m_Values[insertIndex] != data) {
            if (this.m_NumValues < this.m_Values.length) {
                int left = this.m_NumValues - insertIndex;
                System.arraycopy(this.m_Values, insertIndex, this.m_Values, insertIndex + 1, left);
                System.arraycopy(this.m_CondValues, insertIndex, this.m_CondValues, insertIndex + 1, left);
                System.arraycopy(this.m_Weights, insertIndex, this.m_Weights, insertIndex + 1, left);
                this.m_Values[insertIndex] = data;
                this.m_CondValues[insertIndex] = given;
                this.m_Weights[insertIndex] = weight;
                ++this.m_NumValues;
            } else {
                double[] newValues = new double[this.m_Values.length * 2];
                double[] newCondValues = new double[this.m_Values.length * 2];
                double[] newWeights = new double[this.m_Values.length * 2];
                int left = this.m_NumValues - insertIndex;
                System.arraycopy(this.m_Values, 0, newValues, 0, insertIndex);
                System.arraycopy(this.m_CondValues, 0, newCondValues, 0, insertIndex);
                System.arraycopy(this.m_Weights, 0, newWeights, 0, insertIndex);
                newValues[insertIndex] = data;
                newCondValues[insertIndex] = given;
                newWeights[insertIndex] = weight;
                System.arraycopy(this.m_Values, insertIndex, newValues, insertIndex + 1, left);
                System.arraycopy(this.m_CondValues, insertIndex, newCondValues, insertIndex + 1, left);
                System.arraycopy(this.m_Weights, insertIndex, newWeights, insertIndex + 1, left);
                ++this.m_NumValues;
                this.m_Values = newValues;
                this.m_CondValues = newCondValues;
                this.m_Weights = newWeights;
            }
            if (weight != 1.0) {
                this.m_AllWeightsOne = false;
            }
        } else {
            int n = insertIndex;
            this.m_Weights[n] = this.m_Weights[n] + weight;
            this.m_AllWeightsOne = false;
        }
        this.m_SumOfWeights += weight;
        double range = this.m_CondValues[this.m_NumValues - 1] - this.m_CondValues[0];
        this.m_StandardDev = Math.max(range / Math.sqrt(this.m_SumOfWeights), this.m_Precision / 6.0);
    }

    @Override
    public Estimator getEstimator(double given) {
        KernelEstimator result = new KernelEstimator(this.m_Precision);
        if (this.m_NumValues == 0) {
            return result;
        }
        double delta = 0.0;
        double currentProb = 0.0;
        for (int i = 0; i < this.m_NumValues; ++i) {
            delta = this.m_CondValues[i] - given;
            double zLower = (delta - this.m_Precision / 2.0) / this.m_StandardDev;
            double zUpper = (delta + this.m_Precision / 2.0) / this.m_StandardDev;
            currentProb = Statistics.normalProbability(zUpper) - Statistics.normalProbability(zLower);
            ((Estimator)result).addValue(this.m_Values[i], currentProb * this.m_Weights[i]);
        }
        return result;
    }

    @Override
    public double getProbability(double data, double given) {
        return this.getEstimator(given).getProbability(data);
    }

    public String toString() {
        String result = "KK Conditional Estimator. " + this.m_NumValues + " Normal Kernels:\nStandardDev = " + Utils.doubleToString(this.m_StandardDev, 4, 2) + "  \nMeans =";
        for (int i = 0; i < this.m_NumValues; ++i) {
            result = result + " (" + this.m_Values[i] + ", " + this.m_CondValues[i] + ")";
            if (this.m_AllWeightsOne) continue;
            result = result + "w=" + this.m_Weights[i];
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] argv) {
        try {
            int seed = 42;
            if (argv.length > 0) {
                seed = Integer.parseInt(argv[0]);
            }
            KKConditionalEstimator newEst = new KKConditionalEstimator(0.1);
            Random r = new Random(seed);
            int numPoints = 50;
            if (argv.length > 2) {
                numPoints = Integer.parseInt(argv[2]);
            }
            for (int i = 0; i < numPoints; ++i) {
                int x = Math.abs(r.nextInt() % 100);
                int y = Math.abs(r.nextInt() % 100);
                System.out.println("# " + x + "  " + y);
                newEst.addValue(x, y, 1.0);
            }
            int cond = argv.length > 1 ? Integer.parseInt(argv[1]) : Math.abs(r.nextInt() % 100);
            System.out.println("## Conditional = " + cond);
            Estimator result = newEst.getEstimator(cond);
            for (int i = 0; i <= 100; i += 5) {
                System.out.println(" " + i + "  " + result.getProbability(i));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

