/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.weka;

public final class AssertArg {
    private AssertArg() {
    }

    public static <T> T isNull(T value) {
        return AssertArg.isNull(value, "Not null: " + value);
    }

    public static <T> T isNull(T value, String message) {
        if (value != null) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static <T> T notNull(T value) {
        return AssertArg.notNull(value, "Null value");
    }

    public static <T> T notNull(T value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static Boolean isTrue(Boolean value) {
        return AssertArg.isTrue(value, "Not true");
    }

    public static Boolean isTrue(Boolean value, String message) {
        if (!Boolean.valueOf(value).booleanValue()) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static Boolean isFalse(Boolean value) {
        return AssertArg.isFalse(value, "Not false");
    }

    public static Boolean isFalse(Boolean value, String message) {
        if (Boolean.valueOf(value).booleanValue()) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static <T> T isEqual(T exp, T was) {
        return AssertArg.isEqual(exp, was, exp + " != " + was);
    }

    public static <T> T isEqual(T exp, T was, String message) {
        AssertArg.notNull(exp, message);
        AssertArg.notNull(was, message);
        AssertArg.isTrue(exp.equals(was), message);
        return was;
    }

    public static <T> T isSame(T exp, T was) {
        return AssertArg.isSame(exp, was, exp + " != " + was);
    }

    public static <T> T isSame(T exp, T was, String message) {
        AssertArg.notNull(exp, message);
        AssertArg.notNull(was, message);
        AssertArg.isTrue(exp == was, message);
        return was;
    }
}

