/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.weka;

import io.nessus.weka.UncheckedException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import weka.classifiers.Classifier;

public class ModelLoader
implements Supplier<Classifier> {
    private final Path inpath;

    public ModelLoader(String inpath) {
        this(Paths.get(inpath, new String[0]));
    }

    public ModelLoader(Path inpath) {
        this.inpath = inpath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Classifier get() {
        try (FileInputStream instream = new FileInputStream(this.inpath.toFile());){
            Classifier classifier = (Classifier)new ObjectInputStream(instream).readObject();
            return classifier;
        }
        catch (IOException | ClassNotFoundException ex) {
            throw UncheckedException.create(ex);
        }
    }
}

