/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weka;

import io.nessus.weka.AssertState;
import io.nessus.weka.Dataset;
import io.nessus.weka.ModelLoader;
import io.nessus.weka.ModelPersister;
import java.io.ByteArrayInputStream;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.weka.WekaConfiguration;
import org.apache.camel.component.weka.WekaEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instances;

public class WekaProducer
extends DefaultProducer {
    static final Logger LOG = LoggerFactory.getLogger(WekaProducer.class);

    public WekaProducer(WekaEndpoint endpoint) {
        super((Endpoint)endpoint);
        WekaConfiguration.Command cmd = this.getConfiguration().getCommand();
        AssertState.notNull((Object)((Object)cmd), (String)"Null command");
    }

    public WekaEndpoint getEndpoint() {
        return (WekaEndpoint)super.getEndpoint();
    }

    public WekaConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public void process(Exchange exchange) throws Exception {
        WekaEndpoint endpoint = this.getEndpoint();
        WekaConfiguration.Command cmd = this.getConfiguration().getCommand();
        if (WekaConfiguration.Command.version == cmd) {
            Message msg = exchange.getMessage();
            msg.setBody((Object)endpoint.wekaVersion());
        } else if (WekaConfiguration.Command.read == cmd) {
            Dataset dataset = this.handleReadCmd(exchange);
            exchange.getMessage().setBody((Object)dataset);
        } else if (WekaConfiguration.Command.write == cmd) {
            Object result = this.handleWriteCmd(exchange);
            exchange.getMessage().setBody(result);
        } else if (WekaConfiguration.Command.filter == cmd) {
            Dataset dataset = this.handleFilterCmd(exchange);
            exchange.getMessage().setBody((Object)dataset);
        } else if (WekaConfiguration.Command.model == cmd) {
            Dataset dataset = this.handleModelCmd(exchange);
            exchange.getMessage().setBody((Object)dataset);
        } else if (WekaConfiguration.Command.push == cmd) {
            Dataset dataset = this.handlePushCmd(exchange);
            exchange.getMessage().setBody((Object)dataset);
        } else if (WekaConfiguration.Command.pop == cmd) {
            Dataset dataset = this.handlePopCmd(exchange);
            exchange.getMessage().setBody((Object)dataset);
        } else {
            throw new UnsupportedOperationException("Unsupported on Producer: " + (Object)((Object)cmd));
        }
    }

    Dataset handlePushCmd(Exchange exchange) throws Exception {
        String dsname = this.getConfiguration().getDsname();
        Dataset dataset = this.assertDatasetBody(exchange);
        if (dsname != null) {
            dataset.push(dsname);
        } else {
            dataset.push();
        }
        return dataset;
    }

    Dataset handlePopCmd(Exchange exchange) throws Exception {
        String dsname = this.getConfiguration().getDsname();
        Dataset dataset = this.assertDatasetBody(exchange);
        if (dsname != null) {
            dataset.pop(dsname);
        } else {
            dataset.pop();
        }
        return dataset;
    }

    Dataset handleReadCmd(Exchange exchange) throws Exception {
        String fpath = this.getConfiguration().getPath();
        if (fpath != null) {
            Dataset dataset = Dataset.create((String)fpath);
            return dataset;
        }
        Dataset dataset = this.assertDatasetBody(exchange);
        return dataset;
    }

    Object handleWriteCmd(Exchange exchange) throws Exception {
        Dataset dataset = this.assertDatasetBody(exchange);
        String fpath = this.getConfiguration().getPath();
        if (fpath != null) {
            dataset.write(Paths.get(fpath, new String[0]));
            return dataset;
        }
        Instances instances = dataset.getInstances();
        byte[] bytes = instances.toString().getBytes();
        return new ByteArrayInputStream(bytes);
    }

    Dataset handleFilterCmd(Exchange exchange) throws Exception {
        String applyValue = this.getConfiguration().getApply();
        Dataset dataset = this.assertDatasetBody(exchange);
        dataset = dataset.apply(applyValue);
        return dataset;
    }

    Dataset handleModelCmd(Exchange exchange) throws Exception {
        Dataset dataset = this.assertDatasetBody(exchange);
        String dsname = this.getConfiguration().getDsname();
        boolean crossValidate = this.getConfiguration().isXval();
        String buildSpec = this.getConfiguration().getBuild();
        String loadFrom = this.getConfiguration().getLoadFrom();
        String saveTo = this.getConfiguration().getSaveTo();
        if (loadFrom != null) {
            Classifier cl = dataset.loadClassifier((Supplier)new ModelLoader(loadFrom)).getClassifier();
            AssertState.notNull((Object)cl, (String)("Cannot load the classifier from: " + loadFrom));
            LOG.debug("{}", (Object)cl);
        } else if (buildSpec != null) {
            dataset.buildClassifier(buildSpec);
            if (crossValidate) {
                int seed = this.getConfiguration().getSeed();
                int folds = this.getConfiguration().getFolds();
                dataset.crossValidateModel(folds, seed);
            } else {
                if (dsname != null) {
                    dataset.pop(dsname);
                }
                dataset.evaluateModel();
            }
            Classifier cl = dataset.getClassifier();
            AssertState.notNull((Object)cl, (String)"Model command requires 'load' or 'apply'");
            LOG.debug("{}", (Object)cl);
            Evaluation ev = dataset.getEvaluation();
            LOG.debug("{}", (Object)ev.toSummaryString());
        }
        if (saveTo != null) {
            dataset.consumeClassifier((Consumer)new ModelPersister(saveTo));
        }
        return dataset;
    }

    private Dataset assertDatasetBody(Exchange exchange) throws Exception {
        Message msg = exchange.getMessage();
        Dataset dataset = (Dataset)msg.getBody(Dataset.class);
        AssertState.notNull((Object)dataset, (String)("Cannot obtain dataset from body: " + msg.getBody()));
        return dataset;
    }
}

