/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.ValueHolder;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultModel;
import org.apache.camel.impl.engine.DefaultExecutorServiceManager;
import org.apache.camel.impl.engine.RouteService;
import org.apache.camel.impl.engine.SimpleCamelContext;
import org.apache.camel.impl.engine.TransformerKey;
import org.apache.camel.impl.engine.ValidatorKey;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.ModelReifierFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.Validator;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCamelContext
extends SimpleCamelContext
implements ModelCamelContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCamelContext.class);
    private Model model = new DefaultModel((CamelContext)this);

    public DefaultCamelContext() {
        this(true);
    }

    public DefaultCamelContext(BeanRepository repository) {
        this((Registry)new DefaultRegistry(new BeanRepository[]{repository}));
    }

    public DefaultCamelContext(Registry registry) {
        this();
        this.setRegistry(registry);
    }

    public DefaultCamelContext(boolean init) {
        super(init);
    }

    public void disposeModel() {
        LOG.debug("Disposing Model on CamelContext");
        this.model = null;
    }

    public void addModelLifecycleStrategy(ModelLifecycleStrategy modelLifecycleStrategy) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addModelLifecycleStrategy(modelLifecycleStrategy);
    }

    public List<ModelLifecycleStrategy> getModelLifecycleStrategies() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getModelLifecycleStrategies();
    }

    public List<RouteDefinition> getRouteDefinitions() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getRouteDefinitions();
    }

    public RouteDefinition getRouteDefinition(String id) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getRouteDefinition(id);
    }

    public void addRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRouteDefinitions(routeDefinitions);
    }

    public void addRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRouteDefinition(routeDefinition);
    }

    public void removeRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.removeRouteDefinitions(routeDefinitions);
    }

    public void removeRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.removeRouteDefinition(routeDefinition);
    }

    public List<RouteTemplateDefinition> getRouteTemplateDefinitions() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getRouteTemplateDefinitions();
    }

    public RouteTemplateDefinition getRouteTemplateDefinition(String id) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getRouteTemplateDefinition(id);
    }

    public void addRouteTemplateDefinitions(Collection<RouteTemplateDefinition> routeTemplateDefinitions) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRouteTemplateDefinitions(routeTemplateDefinitions);
    }

    public void addRouteTemplateDefinition(RouteTemplateDefinition routeTemplateDefinition) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRouteTemplateDefinition(routeTemplateDefinition);
    }

    public void removeRouteTemplateDefinitions(Collection<RouteTemplateDefinition> routeTemplateDefinitions) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.removeRouteTemplateDefinitions(routeTemplateDefinitions);
    }

    public void removeRouteTemplateDefinition(RouteTemplateDefinition routeTemplateDefinition) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.removeRouteTemplateDefinition(routeTemplateDefinition);
    }

    public void addRouteTemplateDefinitionConverter(String templateIdPattern, RouteTemplateDefinition.Converter converter) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRouteTemplateDefinitionConverter(templateIdPattern, converter);
    }

    public String addRouteFromTemplate(String routeId, String routeTemplateId, Map<String, Object> parameters) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.addRouteFromTemplate(routeId, routeTemplateId, parameters);
    }

    public List<RestDefinition> getRestDefinitions() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getRestDefinitions();
    }

    public void addRestDefinitions(Collection<RestDefinition> restDefinitions, boolean addToRoutes) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRestDefinitions(restDefinitions, addToRoutes);
    }

    public void setDataFormats(Map<String, DataFormatDefinition> dataFormats) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setDataFormats(dataFormats);
    }

    public Map<String, DataFormatDefinition> getDataFormats() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getDataFormats();
    }

    public DataFormatDefinition resolveDataFormatDefinition(String name) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.resolveDataFormatDefinition(name);
    }

    public ProcessorDefinition<?> getProcessorDefinition(String id) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getProcessorDefinition(id);
    }

    public <T extends ProcessorDefinition<T>> T getProcessorDefinition(String id, Class<T> type) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return (T)this.model.getProcessorDefinition(id, type);
    }

    public void setValidators(List<ValidatorDefinition> validators) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setValidators(validators);
    }

    public HystrixConfigurationDefinition getHystrixConfiguration(String id) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getHystrixConfiguration(id);
    }

    public void setHystrixConfiguration(HystrixConfigurationDefinition configuration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setHystrixConfiguration(configuration);
    }

    public void setHystrixConfigurations(List<HystrixConfigurationDefinition> configurations) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setHystrixConfigurations(configurations);
    }

    public void addHystrixConfiguration(String id, HystrixConfigurationDefinition configuration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addHystrixConfiguration(id, configuration);
    }

    public Resilience4jConfigurationDefinition getResilience4jConfiguration(String id) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getResilience4jConfiguration(id);
    }

    public void setResilience4jConfiguration(Resilience4jConfigurationDefinition configuration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setResilience4jConfiguration(configuration);
    }

    public void setResilience4jConfigurations(List<Resilience4jConfigurationDefinition> configurations) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setResilience4jConfigurations(configurations);
    }

    public void addResilience4jConfiguration(String id, Resilience4jConfigurationDefinition configuration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addResilience4jConfiguration(id, configuration);
    }

    public FaultToleranceConfigurationDefinition getFaultToleranceConfiguration(String id) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getFaultToleranceConfiguration(id);
    }

    public void setFaultToleranceConfiguration(FaultToleranceConfigurationDefinition configuration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setFaultToleranceConfiguration(configuration);
    }

    public void setFaultToleranceConfigurations(List<FaultToleranceConfigurationDefinition> configurations) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setFaultToleranceConfigurations(configurations);
    }

    public void addFaultToleranceConfiguration(String id, FaultToleranceConfigurationDefinition configuration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addFaultToleranceConfiguration(id, configuration);
    }

    public List<ValidatorDefinition> getValidators() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getValidators();
    }

    public void setTransformers(List<TransformerDefinition> transformers) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setTransformers(transformers);
    }

    public List<TransformerDefinition> getTransformers() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getTransformers();
    }

    public ServiceCallConfigurationDefinition getServiceCallConfiguration(String serviceName) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getServiceCallConfiguration(serviceName);
    }

    public void setServiceCallConfiguration(ServiceCallConfigurationDefinition configuration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setServiceCallConfiguration(configuration);
    }

    public void setServiceCallConfigurations(List<ServiceCallConfigurationDefinition> configurations) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setServiceCallConfigurations(configurations);
    }

    public void addServiceCallConfiguration(String serviceName, ServiceCallConfigurationDefinition configuration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addServiceCallConfiguration(serviceName, configuration);
    }

    public void setRouteFilterPattern(String include, String exclude) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setRouteFilterPattern(include, exclude);
    }

    public void setRouteFilter(Function<RouteDefinition, Boolean> filter) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setRouteFilter(filter);
    }

    public Function<RouteDefinition, Boolean> getRouteFilter() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getRouteFilter();
    }

    public ModelReifierFactory getModelReifierFactory() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getModelReifierFactory();
    }

    public void setModelReifierFactory(ModelReifierFactory modelReifierFactory) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setModelReifierFactory(modelReifierFactory);
    }

    protected void doStartStandardServices() {
        super.doStartStandardServices();
    }

    protected void bindDataFormats() throws Exception {
        if (this.model != null) {
            for (Map.Entry e : this.model.getDataFormats().entrySet()) {
                String id = (String)e.getKey();
                DataFormatDefinition def = (DataFormatDefinition)e.getValue();
                LOG.debug("Creating Dataformat with id: {} and definition: {}", (Object)id, (Object)def);
                DataFormat df = this.model.getModelReifierFactory().createDataFormat((CamelContext)this, (Object)def);
                this.addService(df, true);
                this.getRegistry().bind(id, (Object)df);
            }
        }
    }

    protected synchronized void shutdownRouteService(RouteService routeService) throws Exception {
        RouteDefinition rd;
        if (this.model != null && (rd = this.model.getRouteDefinition(routeService.getId())) != null) {
            this.model.getRouteDefinitions().remove(rd);
        }
        super.shutdownRouteService(routeService);
    }

    protected boolean isStreamCachingInUse() throws Exception {
        boolean streamCachingInUse = super.isStreamCachingInUse();
        if (!streamCachingInUse) {
            for (RouteDefinition route : this.model.getRouteDefinitions()) {
                Boolean routeCache = CamelContextHelper.parseBoolean((CamelContext)this, (String)route.getStreamCache());
                if (routeCache == null || !routeCache.booleanValue()) continue;
                streamCachingInUse = true;
                break;
            }
        }
        return streamCachingInUse;
    }

    public void startRouteDefinitions() throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        List routeDefinitions = this.model.getRouteDefinitions();
        if (routeDefinitions != null) {
            this.startRouteDefinitions(routeDefinitions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRouteDefinitions(List<RouteDefinition> routeDefinitions) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        boolean alreadyStartingRoutes = this.isStartingRoutes();
        if (!alreadyStartingRoutes) {
            this.setStartingRoutes(true);
        }
        PropertiesComponent pc = this.getCamelContextReference().getPropertiesComponent();
        try {
            RouteDefinitionHelper.forceAssignIds((CamelContext)this.getCamelContextReference(), routeDefinitions);
            for (RouteDefinition routeDefinition : routeDefinitions) {
                String duplicate = RouteDefinitionHelper.validateUniqueIds((RouteDefinition)routeDefinition, routeDefinitions);
                if (duplicate != null) {
                    throw new FailedToStartRouteException(routeDefinition.getId(), "duplicate id detected: " + duplicate + ". Please correct ids to be unique among all your routes.");
                }
                if (routeDefinition.isTemplate() != null && routeDefinition.isTemplate().booleanValue() && routeDefinition.getTemplateParameters() != null) {
                    Properties prop = new Properties();
                    prop.putAll((Map<?, ?>)routeDefinition.getTemplateParameters());
                    pc.setLocalProperties(prop);
                }
                if (!routeDefinition.isPrepared()) {
                    RouteDefinitionHelper.prepareRoute((CamelContext)this.getCamelContextReference(), (RouteDefinition)routeDefinition);
                    routeDefinition.markPrepared();
                }
                Route route = this.model.getModelReifierFactory().createRoute((CamelContext)this, (Object)routeDefinition);
                RouteService routeService = new RouteService(route);
                this.startRouteService(routeService, true);
                pc.setLocalProperties(null);
            }
        }
        finally {
            if (!alreadyStartingRoutes) {
                this.setStartingRoutes(false);
            }
            pc.setLocalProperties(null);
        }
    }

    protected ExecutorServiceManager createExecutorServiceManager() {
        return new DefaultExecutorServiceManager((CamelContext)this);
    }

    public Processor createErrorHandler(Route route, Processor processor) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getModelReifierFactory().createErrorHandler(route, processor);
    }

    public Expression createExpression(ExpressionDefinition definition) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getModelReifierFactory().createExpression((CamelContext)this, (Object)definition);
    }

    public Predicate createPredicate(ExpressionDefinition definition) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getModelReifierFactory().createPredicate((CamelContext)this, (Object)definition);
    }

    public RouteDefinition adviceWith(RouteDefinition definition, AdviceWithRouteBuilder builder) throws Exception {
        return AdviceWith.adviceWith((RouteDefinition)definition, (CamelContext)this, (RouteBuilder)builder);
    }

    public void registerValidator(ValidatorDefinition def) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.getValidators().add(def);
        Validator validator = this.model.getModelReifierFactory().createValidator((CamelContext)this, (Object)def);
        this.getValidatorRegistry().put(DefaultCamelContext.createValidatorKey(def), (Object)validator);
    }

    private static ValueHolder<String> createValidatorKey(ValidatorDefinition def) {
        return new ValidatorKey(new DataType(def.getType()));
    }

    public void registerTransformer(TransformerDefinition def) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.getTransformers().add(def);
        Transformer transformer = this.model.getModelReifierFactory().createTransformer((CamelContext)this, (Object)def);
        this.getTransformerRegistry().put(DefaultCamelContext.createTransformerKey(def), (Object)transformer);
    }

    private static ValueHolder<String> createTransformerKey(TransformerDefinition def) {
        return ObjectHelper.isNotEmpty((Object)def.getScheme()) ? new TransformerKey(def.getScheme()) : new TransformerKey(new DataType(def.getFromType()), new DataType(def.getToType()));
    }
}

