/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.CompRowMatrix;

class UpperCompRowMatrix
extends AbstractMatrix {
    private int[] rowptr;
    private int[] colind;
    private double[] data;
    private int[] diagind;

    public UpperCompRowMatrix(CompRowMatrix LU, int[] diagind) {
        super(LU);
        this.rowptr = LU.getRowPointers();
        this.colind = LU.getColumnIndices();
        this.data = LU.getData();
        this.diagind = diagind;
    }

    @Override
    public Vector solve(Vector b, Vector x) {
        if (!(b instanceof DenseVector) || !(x instanceof DenseVector)) {
            return super.solve(b, x);
        }
        double[] bd = ((DenseVector)b).getData();
        double[] xd = ((DenseVector)x).getData();
        for (int i = this.numRows - 1; i >= 0; --i) {
            double sum = 0.0;
            for (int j = this.diagind[i] + 1; j < this.rowptr[i + 1]; ++j) {
                sum += this.data[j] * xd[this.colind[j]];
            }
            xd[i] = (bd[i] - sum) / this.data[this.diagind[i]];
        }
        return x;
    }

    @Override
    public Vector transSolve(Vector b, Vector x) {
        if (!(x instanceof DenseVector)) {
            return super.transSolve(b, x);
        }
        x.set(b);
        double[] xd = ((DenseVector)x).getData();
        for (int i = 0; i < this.numRows; ++i) {
            int n = i;
            xd[n] = xd[n] / this.data[this.diagind[i]];
            for (int j = this.diagind[i] + 1; j < this.rowptr[i + 1]; ++j) {
                int n2 = this.colind[j];
                xd[n2] = xd[n2] - this.data[j] * xd[i];
            }
        }
        return x;
    }
}

