/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.AbstractInstance;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.TimeSeriesTranslate;

public class TimeSeriesDelta
extends TimeSeriesTranslate {
    static final long serialVersionUID = 3101490081896634942L;

    @Override
    public String globalInfo() {
        return "An instance filter that assumes instances form time-series data and replaces attribute values in the current instance with the difference between the current value and the equivalent attribute attribute value of some previous (or future) instance. For instances where the time-shifted value is unknown either the instance may be dropped, or missing values used. Skips the class attribute if it is set.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        if (instanceInfo.classIndex() > 0 && !this.getFillWithMissing()) {
            throw new IllegalArgumentException("TimeSeriesDelta: Need to fill in missing values using appropriate option when class index is set.");
        }
        super.setInputFormat(instanceInfo);
        Instances outputFormat = new Instances(instanceInfo, 0);
        for (int i = 0; i < instanceInfo.numAttributes(); ++i) {
            if (i == instanceInfo.classIndex() || !this.m_SelectedCols.isInRange(i)) continue;
            if (outputFormat.attribute(i).isNumeric()) {
                outputFormat.renameAttribute(i, outputFormat.attribute(i).name() + " d" + (this.m_InstanceRange < 0 ? (char)'-' : '+') + Math.abs(this.m_InstanceRange));
                continue;
            }
            throw new UnsupportedAttributeTypeException("Time delta attributes must be numeric!");
        }
        outputFormat.setClassIndex(instanceInfo.classIndex());
        this.setOutputFormat(outputFormat);
        return true;
    }

    @Override
    protected Instance mergeInstances(Instance source, Instance dest) {
        Instances outputFormat = this.outputFormatPeek();
        double[] vals = new double[outputFormat.numAttributes()];
        for (int i = 0; i < vals.length; ++i) {
            if (i != outputFormat.classIndex() && this.m_SelectedCols.isInRange(i)) {
                if (source != null && !source.isMissing(i) && !dest.isMissing(i)) {
                    vals[i] = dest.value(i) - source.value(i);
                    continue;
                }
                vals[i] = Utils.missingValue();
                continue;
            }
            vals[i] = dest.value(i);
        }
        AbstractInstance inst = null;
        inst = dest instanceof SparseInstance ? new SparseInstance(dest.weight(), vals) : new DenseInstance(dest.weight(), vals);
        inst.setDataset(dest.dataset());
        return inst;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] argv) {
        TimeSeriesDelta.runFilter(new TimeSeriesDelta(), argv);
    }
}

