/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.AbstractDenseMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.LowerSPDDenseMatrix;
import no.uib.cipr.matrix.LowerTriangDenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.UpperSPDDenseMatrix;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class DenseCholesky {
    private final int n;
    private LowerTriangDenseMatrix Cl;
    private UpperTriangDenseMatrix Cu;
    private boolean notspd;
    private final boolean upper;

    public DenseCholesky(int n, boolean upper) {
        this.n = n;
        this.upper = upper;
        if (upper) {
            this.Cu = new UpperTriangDenseMatrix(n);
        } else {
            this.Cl = new LowerTriangDenseMatrix(n);
        }
    }

    public static DenseCholesky factorize(Matrix A) {
        return new DenseCholesky(A.numRows(), true).factor(new UpperSPDDenseMatrix(A));
    }

    public DenseCholesky factor(LowerSPDDenseMatrix A) {
        if (this.upper) {
            throw new IllegalArgumentException("Cholesky decomposition constructed for upper matrices");
        }
        return this.decompose(A);
    }

    public DenseCholesky factor(UpperSPDDenseMatrix A) {
        if (!this.upper) {
            throw new IllegalArgumentException("Cholesky decomposition constructed for lower matrices");
        }
        return this.decompose(A);
    }

    private DenseCholesky decompose(AbstractDenseMatrix A) {
        if (this.n != A.numRows()) {
            throw new IllegalArgumentException("n != A.numRows()");
        }
        this.notspd = false;
        intW info = new intW(0);
        if (this.upper) {
            LAPACK.getInstance().dpotrf(UpLo.Upper.netlib(), A.numRows(), A.getData(), Matrices.ld(A.numRows()), info);
        } else {
            LAPACK.getInstance().dpotrf(UpLo.Lower.netlib(), A.numRows(), A.getData(), Matrices.ld(A.numRows()), info);
        }
        if (info.val > 0) {
            this.notspd = true;
        } else if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        if (this.upper) {
            this.Cu.set(A);
        } else {
            this.Cl.set(A);
        }
        return this;
    }

    public boolean isSPD() {
        return !this.notspd;
    }

    public LowerTriangDenseMatrix getL() {
        if (!this.upper) {
            return this.Cl;
        }
        throw new UnsupportedOperationException();
    }

    public UpperTriangDenseMatrix getU() {
        if (this.upper) {
            return this.Cu;
        }
        throw new UnsupportedOperationException();
    }

    public DenseMatrix solve(DenseMatrix B) throws MatrixNotSPDException {
        if (this.notspd) {
            throw new MatrixNotSPDException();
        }
        if (this.n != B.numRows()) {
            throw new IllegalArgumentException("n != B.numRows()");
        }
        intW info = new intW(0);
        if (this.upper) {
            LAPACK.getInstance().dpotrs(UpLo.Upper.netlib(), this.Cu.numRows(), B.numColumns(), this.Cu.getData(), Matrices.ld(this.Cu.numRows()), B.getData(), Matrices.ld(this.Cu.numRows()), info);
        } else {
            LAPACK.getInstance().dpotrs(UpLo.Lower.netlib(), this.Cl.numRows(), B.numColumns(), this.Cl.getData(), Matrices.ld(this.Cl.numRows()), B.getData(), Matrices.ld(this.Cl.numRows()), info);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return B;
    }

    public double rcond(Matrix A) {
        if (this.n != A.numRows()) {
            throw new IllegalArgumentException("n != A.numRows()");
        }
        if (!A.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        double anorm = A.norm(Matrix.Norm.One);
        double[] work = new double[3 * this.n];
        int[] iwork = new int[this.n];
        intW info = new intW(0);
        doubleW rcond = new doubleW(0.0);
        if (this.upper) {
            LAPACK.getInstance().dpocon(UpLo.Upper.netlib(), this.n, this.Cu.getData(), Matrices.ld(this.n), anorm, rcond, work, iwork, info);
        } else {
            LAPACK.getInstance().dpocon(UpLo.Lower.netlib(), this.n, this.Cl.getData(), Matrices.ld(this.n), anorm, rcond, work, iwork, info);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return rcond.val;
    }
}

