/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.minidns.record.Record;

public abstract class Data {
    private byte[] bytes;
    private transient Integer hashCodeCache;

    Data() {
    }

    public abstract Record.TYPE getType();

    protected abstract void serialize(DataOutputStream var1) throws IOException;

    private final void setBytes() {
        if (this.bytes != null) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            this.serialize(dos);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.bytes = baos.toByteArray();
    }

    public final int length() {
        this.setBytes();
        return this.bytes.length;
    }

    public void toOutputStream(DataOutputStream dos) throws IOException {
        this.setBytes();
        dos.write(this.bytes);
    }

    public final byte[] toByteArray() {
        this.setBytes();
        return (byte[])this.bytes.clone();
    }

    public final int hashCode() {
        if (this.hashCodeCache == null) {
            this.setBytes();
            this.hashCodeCache = this.bytes.hashCode();
        }
        return this.hashCodeCache;
    }

    public final boolean equals(Object other) {
        if (!(other instanceof Data)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Data otherData = (Data)other;
        otherData.setBytes();
        this.setBytes();
        return Arrays.equals(this.bytes, otherData.bytes);
    }
}

