/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco.packet;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.Jid;

public class DiscoverItems
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "http://jabber.org/protocol/disco#items";
    private final List<Item> items = new LinkedList<Item>();
    private String node;

    public DiscoverItems() {
        super(ELEMENT, NAMESPACE);
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public void addItems(Collection<Item> itemsToAdd) {
        if (itemsToAdd == null) {
            return;
        }
        for (Item i : itemsToAdd) {
            this.addItem(i);
        }
    }

    public List<Item> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.optAttribute("node", this.getNode());
        xml.rightAngleBracket();
        for (Item item : this.items) {
            xml.append(item.toXML());
        }
        return xml;
    }

    public static class Item {
        public static final String UPDATE_ACTION = "update";
        public static final String REMOVE_ACTION = "remove";
        private final Jid entityID;
        private String name;
        private String node;
        private String action;

        public Item(Jid entityID) {
            this.entityID = entityID;
        }

        public Jid getEntityID() {
            return this.entityID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement("item");
            xml.attribute("jid", (CharSequence)this.entityID);
            xml.optAttribute("name", this.name);
            xml.optAttribute("node", this.node);
            xml.optAttribute("action", this.action);
            xml.closeEmptyElement();
            return xml;
        }
    }
}

