/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ReconnectionListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.util.Async;

public final class ReconnectionManager {
    private static final Logger LOGGER = Logger.getLogger(ReconnectionManager.class.getName());
    private static final Map<AbstractXMPPConnection, ReconnectionManager> INSTANCES = new WeakHashMap<AbstractXMPPConnection, ReconnectionManager>();
    private static boolean enabledPerDefault;
    private final Set<ReconnectionListener> reconnectionListeners = new CopyOnWriteArraySet<ReconnectionListener>();
    private final WeakReference<AbstractXMPPConnection> weakRefConnection;
    private final int randomBase = new Random().nextInt(13) + 2;
    private final Runnable reconnectionRunnable;
    private static int defaultFixedDelay;
    private static ReconnectionPolicy defaultReconnectionPolicy;
    private volatile int fixedDelay = defaultFixedDelay;
    private volatile ReconnectionPolicy reconnectionPolicy = defaultReconnectionPolicy;
    private boolean automaticReconnectEnabled = false;
    boolean done = false;
    private Thread reconnectionThread;
    private final ConnectionListener connectionListener = new AbstractConnectionListener(){

        @Override
        public void connectionClosed() {
            ReconnectionManager.this.done = true;
        }

        @Override
        public void authenticated(XMPPConnection connection, boolean resumed) {
            ReconnectionManager.this.done = false;
        }

        @Override
        public void connectionClosedOnError(Exception e) {
            XMPPException.StreamErrorException xmppEx;
            StreamError error;
            ReconnectionManager.this.done = false;
            if (!ReconnectionManager.this.isAutomaticReconnectEnabled()) {
                return;
            }
            if (e instanceof XMPPException.StreamErrorException && StreamError.Condition.conflict == (error = (xmppEx = (XMPPException.StreamErrorException)e).getStreamError()).getCondition()) {
                return;
            }
            ReconnectionManager.this.reconnect();
        }
    };

    public static synchronized ReconnectionManager getInstanceFor(AbstractXMPPConnection connection) {
        ReconnectionManager reconnectionManager = INSTANCES.get(connection);
        if (reconnectionManager == null) {
            reconnectionManager = new ReconnectionManager(connection);
            INSTANCES.put(connection, reconnectionManager);
        }
        return reconnectionManager;
    }

    public static void setEnabledPerDefault(boolean enabled) {
        enabledPerDefault = enabled;
    }

    public static boolean getEnabledPerDefault() {
        return enabledPerDefault;
    }

    public static void setDefaultFixedDelay(int fixedDelay) {
        defaultFixedDelay = fixedDelay;
        ReconnectionManager.setDefaultReconnectionPolicy(ReconnectionPolicy.FIXED_DELAY);
    }

    public static void setDefaultReconnectionPolicy(ReconnectionPolicy reconnectionPolicy) {
        defaultReconnectionPolicy = reconnectionPolicy;
    }

    public boolean addReconnectionListener(ReconnectionListener listener) {
        return this.reconnectionListeners.add(listener);
    }

    public boolean removeReconnectionListener(ReconnectionListener listener) {
        return this.reconnectionListeners.remove(listener);
    }

    public void setFixedDelay(int fixedDelay) {
        this.fixedDelay = fixedDelay;
        this.setReconnectionPolicy(ReconnectionPolicy.FIXED_DELAY);
    }

    public void setReconnectionPolicy(ReconnectionPolicy reconnectionPolicy) {
        this.reconnectionPolicy = reconnectionPolicy;
    }

    private ReconnectionManager(AbstractXMPPConnection connection) {
        this.weakRefConnection = new WeakReference<AbstractXMPPConnection>(connection);
        this.reconnectionRunnable = new Runnable(){
            private int attempts = 0;

            private int timeDelay() {
                int delay;
                ++this.attempts;
                switch (ReconnectionManager.this.reconnectionPolicy) {
                    case FIXED_DELAY: {
                        delay = ReconnectionManager.this.fixedDelay;
                        break;
                    }
                    case RANDOM_INCREASING_DELAY: {
                        if (this.attempts > 13) {
                            delay = ReconnectionManager.this.randomBase * 6 * 5;
                            break;
                        }
                        if (this.attempts > 7) {
                            delay = ReconnectionManager.this.randomBase * 6;
                            break;
                        }
                        delay = ReconnectionManager.this.randomBase;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown reconnection policy " + (Object)((Object)ReconnectionManager.this.reconnectionPolicy)));
                    }
                }
                return delay;
            }

            @Override
            public void run() {
                AbstractXMPPConnection connection = (AbstractXMPPConnection)ReconnectionManager.this.weakRefConnection.get();
                if (connection == null) {
                    return;
                }
                this.attempts = 0;
                while (ReconnectionManager.this.isReconnectionPossible(connection)) {
                    int remainingSeconds = this.timeDelay();
                    while (remainingSeconds > 0) {
                        if (!ReconnectionManager.this.isReconnectionPossible(connection)) {
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                            --remainingSeconds;
                            for (ReconnectionListener listener : ReconnectionManager.this.reconnectionListeners) {
                                listener.reconnectingIn(remainingSeconds);
                            }
                        }
                        catch (InterruptedException e) {
                            LOGGER.log(Level.FINE, "Reconnection Thread was interrupted, aborting reconnection mechanism", e);
                            return;
                        }
                    }
                    for (ReconnectionListener listener : ReconnectionManager.this.reconnectionListeners) {
                        listener.reconnectingIn(0);
                    }
                    if (!ReconnectionManager.this.isReconnectionPossible(connection)) {
                        return;
                    }
                    try {
                        try {
                            connection.connect();
                        }
                        catch (SmackException.AlreadyConnectedException e) {
                            LOGGER.log(Level.FINER, "Connection was already connected on reconnection attempt", e);
                        }
                        connection.login();
                    }
                    catch (SmackException.AlreadyLoggedInException e) {
                        LOGGER.log(Level.FINER, "Reconnection not required, was already logged in", e);
                    }
                    catch (IOException | SmackException | XMPPException e) {
                        for (ReconnectionListener listener : ReconnectionManager.this.reconnectionListeners) {
                            listener.reconnectionFailed(e);
                        }
                        continue;
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.FINE, "Reconnection Thread was interrupted, aborting reconnection mechanism", e);
                        return;
                    }
                    return;
                }
            }
        };
        if (ReconnectionManager.getEnabledPerDefault()) {
            this.enableAutomaticReconnection();
        }
    }

    public synchronized void enableAutomaticReconnection() {
        if (this.automaticReconnectEnabled) {
            return;
        }
        XMPPConnection connection = (XMPPConnection)this.weakRefConnection.get();
        if (connection == null) {
            throw new IllegalStateException("Connection instance no longer available");
        }
        connection.addConnectionListener(this.connectionListener);
        this.automaticReconnectEnabled = true;
    }

    public synchronized void disableAutomaticReconnection() {
        if (!this.automaticReconnectEnabled) {
            return;
        }
        XMPPConnection connection = (XMPPConnection)this.weakRefConnection.get();
        if (connection == null) {
            throw new IllegalStateException("Connection instance no longer available");
        }
        connection.removeConnectionListener(this.connectionListener);
        this.automaticReconnectEnabled = false;
    }

    public synchronized boolean isAutomaticReconnectEnabled() {
        return this.automaticReconnectEnabled;
    }

    private boolean isReconnectionPossible(XMPPConnection connection) {
        return !this.done && !connection.isConnected() && this.isAutomaticReconnectEnabled();
    }

    private synchronized void reconnect() {
        XMPPConnection connection = (XMPPConnection)this.weakRefConnection.get();
        if (connection == null) {
            LOGGER.fine("Connection is null, will not reconnect");
            return;
        }
        if (this.reconnectionThread != null && this.reconnectionThread.isAlive()) {
            return;
        }
        this.reconnectionThread = Async.go(this.reconnectionRunnable, "Smack Reconnection Manager (" + connection.getConnectionCounter() + ')');
    }

    public synchronized void abortPossiblyRunningReconnection() {
        if (this.reconnectionThread == null) {
            return;
        }
        this.reconnectionThread.interrupt();
        this.reconnectionThread = null;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                if (connection instanceof AbstractXMPPConnection) {
                    ReconnectionManager.getInstanceFor((AbstractXMPPConnection)connection);
                }
            }
        });
        enabledPerDefault = false;
        defaultFixedDelay = 15;
        defaultReconnectionPolicy = ReconnectionPolicy.RANDOM_INCREASING_DELAY;
    }

    public static enum ReconnectionPolicy {
        RANDOM_INCREASING_DELAY,
        FIXED_DELAY;

    }
}

