/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiMap<K, V> {
    public static final int DEFAULT_MAP_SIZE = 6;
    private static final int ENTRY_LIST_SIZE = 3;
    private final Map<K, List<V>> map;

    public MultiMap() {
        this(6);
    }

    public MultiMap(int size) {
        this.map = new LinkedHashMap<K, List<V>>(size);
    }

    public int size() {
        int size = 0;
        for (List<V> list : this.map.values()) {
            size += list.size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        for (List<V> list : this.map.values()) {
            if (!list.contains(value)) continue;
            return true;
        }
        return false;
    }

    public V getFirst(Object key) {
        List<V> res = this.getAll(key);
        if (res.isEmpty()) {
            return null;
        }
        return res.iterator().next();
    }

    public List<V> getAll(Object key) {
        List<Object> res = this.map.get(key);
        if (res == null) {
            res = Collections.emptyList();
        }
        return res;
    }

    public boolean put(K key, V value) {
        boolean keyExisted;
        List<V> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList<V>(3);
            list.add(value);
            this.map.put(key, list);
            keyExisted = false;
        } else {
            list.add(value);
            keyExisted = true;
        }
        return keyExisted;
    }

    public V remove(Object key) {
        List<V> res = this.map.remove(key);
        if (res == null) {
            return null;
        }
        assert (!res.isEmpty());
        return res.iterator().next();
    }

    public boolean removeOne(Object key, V value) {
        List<V> list = this.map.get(key);
        if (list == null) {
            return false;
        }
        boolean res = list.remove(value);
        if (list.isEmpty()) {
            this.map.remove(key);
        }
        return res;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public List<V> values() {
        ArrayList<V> values = new ArrayList<V>(this.size());
        for (List<V> list : this.map.values()) {
            values.addAll(list);
        }
        return values;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> entrySet = new LinkedHashSet<Map.Entry<K, V>>(this.size());
        for (Map.Entry<K, List<V>> entries : this.map.entrySet()) {
            K key = entries.getKey();
            for (V value : entries.getValue()) {
                entrySet.add(new SimpleMapEntry(key, value));
            }
        }
        return entrySet;
    }

    private static final class SimpleMapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        private SimpleMapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V tmp = this.value;
            this.value = value;
            return tmp;
        }
    }
}

