/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.jivesoftware.smack.ReconnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="xmpp")
public class XmppComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(XmppComponent.class);
    private final Map<String, XmppEndpoint> endpointCache = new HashMap<String, XmppEndpoint>();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String remainingPath;
        String cacheKey = this.extractCacheKeyFromUri(uri);
        if (this.endpointCache.containsKey(cacheKey)) {
            LOG.debug("Using cached endpoint for URI {}", (Object)URISupport.sanitizeUri((String)uri));
            return (Endpoint)this.endpointCache.get(cacheKey);
        }
        LOG.debug("Creating new endpoint for URI {}", (Object)URISupport.sanitizeUri((String)uri));
        XmppEndpoint endpoint = new XmppEndpoint(uri, this);
        URI u = new URI(uri);
        endpoint.setHost(u.getHost());
        endpoint.setPort(u.getPort());
        if (u.getUserInfo() != null) {
            String[] parts = u.getUserInfo().split(":");
            if (parts.length == 2) {
                endpoint.setUser(parts[0]);
                endpoint.setPassword(parts[1]);
            } else {
                endpoint.setUser(u.getUserInfo());
            }
        }
        if ((remainingPath = u.getPath()) != null) {
            if (remainingPath.startsWith("/")) {
                remainingPath = remainingPath.substring(1);
            }
            if (remainingPath.length() > 0) {
                endpoint.setParticipant(remainingPath);
            }
        }
        this.endpointCache.put(cacheKey, endpoint);
        return endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ReconnectionManager.setEnabledPerDefault((boolean)true);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.endpointCache.values());
        this.endpointCache.clear();
        super.doStop();
    }

    private String extractCacheKeyFromUri(String uri) throws URISyntaxException {
        URI u = new URI(uri);
        String result = u.getScheme() + "://" + u.getHost() + u.getPort() + u.getQuery();
        return result;
    }
}

