/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common.services.mockweb;

import java.security.KeyStore;
import java.util.stream.IntStream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockWebService
implements BeforeEachCallback,
AfterEachCallback {
    private static final Logger LOG = LoggerFactory.getLogger(MockWebService.class);
    private boolean useHttps;
    private String keystore;
    private String keystorePassword;
    private String truststore;
    private String truststorePassword;
    private MockWebServer server;

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        LOG.debug("Starting MockWebServer...");
        this.server = new MockWebServer();
        if (this.useHttps) {
            KeyManagerFactory kmFactory = null;
            if (this.keystore != null) {
                KeyStore keyStore = KeyStore.getInstance("JKS");
                String password = this.keystorePassword == null ? "" : this.keystorePassword;
                keyStore.load(this.getClass().getResourceAsStream(this.keystore), password.toCharArray());
                kmFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmFactory.init(keyStore, password.toCharArray());
            }
            TrustManagerFactory tmFactory = null;
            if (this.truststore != null) {
                KeyStore trustStore = KeyStore.getInstance("JKS");
                String password = this.truststorePassword == null ? "" : this.truststorePassword;
                trustStore.load(this.getClass().getResourceAsStream(this.truststore), password.toCharArray());
                tmFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                tmFactory.init(trustStore);
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmFactory == null ? null : kmFactory.getKeyManagers(), tmFactory == null ? null : tmFactory.getTrustManagers(), null);
            this.server.useHttps(sslContext.getSocketFactory(), false);
            LOG.debug("Use HTTPS: keystore={}, truststore={}", (Object)this.keystore, (Object)this.truststore);
        }
        this.server.start();
        LOG.info("MockWebServer started");
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        if (this.server != null) {
            this.server.shutdown();
            this.server = null;
            LOG.info("MockWebServer shutdown");
        }
    }

    public void enqueueResponses(int count) {
        IntStream.range(0, count).forEach(i -> this.server.enqueue(new MockResponse().setResponseCode(200)));
    }

    public MockWebServer getServer() {
        return this.server;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean useHttps;
        private String keystore;
        private String keystorePassword;
        private String truststore;
        private String truststorePassword;

        public Builder useHttps() {
            this.useHttps = true;
            return this;
        }

        public Builder withKeystore(String store, String password) {
            this.keystore = store;
            this.keystorePassword = password;
            return this;
        }

        public Builder withTruststore(String store, String password) {
            this.truststore = store;
            this.truststorePassword = password;
            return this;
        }

        public MockWebService build() {
            MockWebService service = new MockWebService();
            service.useHttps = this.useHttps;
            service.keystore = this.keystore;
            service.keystorePassword = this.keystorePassword;
            service.truststore = this.truststore;
            service.truststorePassword = this.truststorePassword;
            return service;
        }
    }
}

