/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common;

import org.apache.camel.kafkaconnector.common.PluginPathHelper;
import org.apache.camel.kafkaconnector.common.services.kafka.EmbeddedKafkaService;
import org.apache.camel.kafkaconnector.common.services.kafkaconnect.KafkaConnectRunnerFactory;
import org.apache.camel.kafkaconnector.common.services.kafkaconnect.KafkaConnectService;
import org.apache.camel.kafkaconnector.common.utils.PropertyUtils;
import org.apache.camel.kafkaconnector.common.utils.TestUtils;
import org.apache.camel.test.infra.kafka.services.ContainerLocalKafkaService;
import org.apache.camel.test.infra.kafka.services.KafkaService;
import org.apache.camel.test.infra.kafka.services.KafkaServiceFactory;
import org.apache.camel.test.infra.kafka.services.RemoteKafkaService;
import org.apache.camel.test.infra.kafka.services.StrimziService;
import org.junit.jupiter.api.extension.RegisterExtension;

public abstract class AbstractKafkaTest {
    @RegisterExtension
    public final KafkaService kafkaService;
    @RegisterExtension
    public final KafkaConnectService kafkaConnectService;

    public AbstractKafkaTest() {
        PluginPathHelper.getInstance().registerConnector(this.getConnectorsInTest());
        this.kafkaService = (KafkaService)KafkaServiceFactory.builder().addLocalMapping(EmbeddedKafkaService::new).addRemoteMapping(RemoteKafkaService::new).addMapping("embedded", EmbeddedKafkaService::new).addMapping("local-strimzi-container", StrimziService::new).addMapping("local-cp-kafka-container", ContainerLocalKafkaService::new).build();
        this.kafkaService.initialize();
        this.kafkaConnectService = KafkaConnectRunnerFactory.createService(this.kafkaService);
    }

    protected abstract String[] getConnectorsInTest();

    public KafkaService getKafkaService() {
        return this.kafkaService;
    }

    public KafkaConnectService getKafkaConnectService() {
        return this.kafkaConnectService;
    }

    protected String getTopicForTest(Object testObject) {
        return TestUtils.getDefaultTestTopic(testObject.getClass()) + "." + TestUtils.randomWithRange(0, 1000);
    }

    static {
        PropertyUtils.load();
    }
}

