/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common.services.kafkaconnect;

import java.util.Properties;
import org.apache.camel.kafkaconnector.common.PluginPathHelper;
import org.apache.camel.kafkaconnector.common.services.kafkaconnect.KafkaConnectPropertyFactory;
import org.apache.camel.kafkaconnector.common.utils.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultKafkaConnectPropertyFactory
implements KafkaConnectPropertyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultKafkaConnectPropertyFactory.class);
    private final String bootstrapServer;

    public DefaultKafkaConnectPropertyFactory(String bootstrapServer) {
        this.bootstrapServer = bootstrapServer;
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServer);
        props.put("key.converter", "org.apache.kafka.connect.json.JsonConverter");
        props.put("value.converter", "org.apache.kafka.connect.json.JsonConverter");
        props.put("offset.storage.file.filename", this.getClass().getResource("/").getPath() + "connect.offsets");
        props.put("offset.flush.interval.ms", "10000");
        String address = NetworkUtils.getAddress("http");
        LOG.info("Using the following address for  the listener configuration: {}", (Object)address);
        props.put("listeners", address);
        String pluginPaths = PluginPathHelper.getInstance().pluginPaths();
        props.put("plugin.path", pluginPaths);
        return props;
    }
}

