/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common;

import org.apache.camel.kafkaconnector.common.PluginPathHelper;
import org.apache.camel.kafkaconnector.common.clients.kafka.KafkaClient;
import org.apache.camel.kafkaconnector.common.services.kafka.KafkaService;
import org.apache.camel.kafkaconnector.common.services.kafka.KafkaServiceFactory;
import org.apache.camel.kafkaconnector.common.services.kafkaconnect.KafkaConnectRunnerFactory;
import org.apache.camel.kafkaconnector.common.services.kafkaconnect.KafkaConnectService;
import org.apache.camel.kafkaconnector.common.utils.PropertyUtils;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public abstract class AbstractKafkaTest {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractKafkaTest.class);
    @RegisterExtension
    public final KafkaService kafkaService;
    @RegisterExtension
    public final KafkaConnectService kafkaConnectService;

    public AbstractKafkaTest() {
        PluginPathHelper.getInstance().registerConnector(this.getConnectorsInTest());
        this.kafkaService = KafkaServiceFactory.createService();
        this.kafkaService.initialize();
        this.kafkaConnectService = KafkaConnectRunnerFactory.createService(this.kafkaService);
    }

    protected abstract String[] getConnectorsInTest();

    public KafkaService getKafkaService() {
        return this.kafkaService;
    }

    public KafkaConnectService getKafkaConnectService() {
        return this.kafkaConnectService;
    }

    protected void deleteKafkaTopic(String topic) {
        try {
            KafkaClient kafkaClient = new KafkaClient(this.getKafkaService().getBootstrapServers());
            kafkaClient.deleteTopic(topic);
        }
        catch (Throwable t) {
            LOG.warn("Topic not deleted (probably the Kafka test cluster was already shutting down?).", t);
        }
    }

    static {
        PropertyUtils.load();
    }
}

