/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.kafkaconnector.common.ConnectorPropertyFactory;
import org.apache.camel.kafkaconnector.common.TransformsConfigBuilder;

public abstract class BasicConnectorPropertyFactory<T extends BasicConnectorPropertyFactory<T>>
implements ConnectorPropertyFactory {
    private Properties connectorProps = new Properties();

    public T withName(String name) {
        this.connectorProps.put("name", name);
        return (T)this;
    }

    public T withTasksMax(int tasksMax) {
        this.connectorProps.put("tasks.max", String.valueOf(tasksMax));
        return (T)this;
    }

    public T withConnectorClass(String connectorClass) {
        this.connectorProps.put("connector.class", connectorClass);
        return (T)this;
    }

    public T withKeyConverterClass(String converterClass) {
        this.connectorProps.put("key.converter", converterClass);
        return (T)this;
    }

    public T withValueConverterClass(String converterClass) {
        this.connectorProps.put("value.converter", converterClass);
        return (T)this;
    }

    public TransformsConfigBuilder<T> withTransformsConfig(String name) {
        return new TransformsConfigBuilder<BasicConnectorPropertyFactory>(this, this.getProperties(), name);
    }

    protected T setProperty(String name, Object value) {
        this.connectorProps.put(name, value);
        return (T)this;
    }

    public static String classRef(String className) {
        return "#class:" + className;
    }

    public T merge(Properties properties) {
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        this.connectorProps.putAll(set.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b)));
        return (T)this;
    }

    @Override
    public Properties getProperties() {
        return this.connectorProps;
    }
}

