/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common.utils;

import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestUtils.class);

    private TestUtils() {
    }

    public static String getDefaultTestTopic(Class<?> clazz) {
        return clazz.getName();
    }

    public static <T> void waitFor(Predicate<T> resourceCheck, T payload) {
        boolean state;
        int retries = 30;
        int waitTime = 1000;
        do {
            try {
                state = resourceCheck.test(payload);
                if (state) continue;
                LOG.debug("The resource is not yet available. Waiting {} seconds before retrying", (Object)TimeUnit.MILLISECONDS.toSeconds(waitTime));
                --retries;
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                break;
            }
        } while (!state && retries > 0);
    }

    public static void waitFor(BooleanSupplier resourceCheck) {
        boolean state;
        int retries = 30;
        int waitTime = 1000;
        do {
            try {
                state = resourceCheck.getAsBoolean();
                if (state) continue;
                LOG.debug("The resource is not yet available. Waiting {} seconds before retrying", (Object)TimeUnit.MILLISECONDS.toSeconds(waitTime));
                --retries;
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                break;
            }
        } while (!state && retries > 0);
    }

    public static int randomWithRange(int min, int max) {
        int range = max - min + 1;
        return (int)(Math.random() * (double)range) + min;
    }
}

