/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common.services.kafka;

import org.apache.camel.kafkaconnector.common.services.kafka.KafkaService;
import org.apache.camel.kafkaconnector.common.services.kafka.StrimziContainer;
import org.apache.camel.kafkaconnector.common.services.kafka.ZookeeperContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;

public class StrimziService
implements KafkaService {
    private static final Logger LOG = LoggerFactory.getLogger(StrimziService.class);
    private final ZookeeperContainer zookeeperContainer;
    private final StrimziContainer strimziContainer;

    public StrimziService() {
        Network network = Network.newNetwork();
        this.zookeeperContainer = new ZookeeperContainer(network, "zookeeper");
        this.strimziContainer = new StrimziContainer(network, "strimzi");
    }

    private Integer getKafkaPort() {
        return this.strimziContainer.getKafkaPort();
    }

    @Override
    public String getBootstrapServers() {
        return this.strimziContainer.getContainerIpAddress() + ":" + this.getKafkaPort();
    }

    @Override
    public void initialize() {
        this.zookeeperContainer.start();
        String zookeeperConnect = "zookeeper:" + this.zookeeperContainer.getZookeeperPort();
        LOG.info("Apache Zookeeper running at address {}", (Object)zookeeperConnect);
        this.strimziContainer.start();
        LOG.info("Kafka bootstrap server running at address {}", (Object)this.getBootstrapServers());
    }

    @Override
    public void shutdown() {
        try {
            LOG.info("Stopping Kafka container");
            this.strimziContainer.stop();
        }
        finally {
            LOG.info("Stopping Zookeeper container");
            this.zookeeperContainer.stop();
        }
    }
}

