/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common.services.kafkaconnect;

import org.apache.camel.kafkaconnector.common.services.kafka.EmbeddedKafkaService;
import org.apache.camel.kafkaconnector.common.services.kafka.KafkaService;
import org.apache.camel.kafkaconnector.common.services.kafkaconnect.KafkaConnectEmbedded;
import org.apache.camel.kafkaconnector.common.services.kafkaconnect.KafkaConnectRunnerService;
import org.apache.camel.kafkaconnector.common.services.kafkaconnect.KafkaConnectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaConnectRunnerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaConnectRunnerFactory.class);

    private KafkaConnectRunnerFactory() {
    }

    public static KafkaConnectService createService(KafkaService kafkaService) {
        if (kafkaService instanceof EmbeddedKafkaService) {
            LOG.info("Using the Kafka embedded Kafka service");
            return new KafkaConnectEmbedded(kafkaService);
        }
        LOG.info("Using the custom Kafka service");
        return new KafkaConnectRunnerService(kafkaService);
    }
}

