/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.kafkaconnector.common.ComponentConfigBuilder;
import org.apache.camel.kafkaconnector.common.ConnectorPropertyFactory;
import org.apache.camel.kafkaconnector.common.IdempotencyConfigBuilder;
import org.apache.camel.kafkaconnector.common.TransformsConfigBuilder;

public abstract class BasicConnectorPropertyFactory<T extends BasicConnectorPropertyFactory<T>>
implements ConnectorPropertyFactory {
    private final Properties connectorProps = new Properties();

    public T withName(String name) {
        this.connectorProps.put("name", name);
        return (T)this;
    }

    public T withTasksMax(int tasksMax) {
        this.connectorProps.put("tasks.max", String.valueOf(tasksMax));
        return (T)this;
    }

    public T withConnectorClass(String connectorClass) {
        this.connectorProps.put("connector.class", connectorClass);
        return (T)this;
    }

    public T withKeyConverterClass(String converterClass) {
        this.connectorProps.put("key.converter", converterClass);
        return (T)this;
    }

    public T withBeans(String name, String value) {
        this.connectorProps.put("camel.beans." + name, value);
        return (T)this;
    }

    public T withValueConverterClass(String converterClass) {
        this.connectorProps.put("value.converter", converterClass);
        return (T)this;
    }

    public IdempotencyConfigBuilder<T> withIdempotency() {
        return new IdempotencyConfigBuilder<BasicConnectorPropertyFactory>(this, this.connectorProps);
    }

    public T withDeadLetterQueueTopicName(String topicName) {
        this.connectorProps.put("errors.deadletterqueue.topic.name", topicName);
        this.connectorProps.put("errors.deadletterqueue.topic.replication.factor", (Object)1);
        this.connectorProps.put("errors.log.enable", (Object)true);
        return (T)this;
    }

    public TransformsConfigBuilder<T> withTransformsConfig(String name) {
        return new TransformsConfigBuilder<BasicConnectorPropertyFactory>(this, this.getProperties(), name);
    }

    public ComponentConfigBuilder<T> withComponentConfig(String name, String value) {
        return new ComponentConfigBuilder<BasicConnectorPropertyFactory>(this, this.getProperties(), name, value);
    }

    public T setProperty(String name, Object value) {
        this.connectorProps.put(name, value);
        return (T)this;
    }

    public static String classRef(String className) {
        return "#class:" + className;
    }

    public T merge(Properties properties) {
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        this.connectorProps.putAll(set.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b)));
        return (T)this;
    }

    @Override
    public Properties getProperties() {
        return this.connectorProps;
    }
}

