/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common.services.kafkaconnect;

import java.util.Properties;
import org.apache.camel.kafkaconnector.common.PluginPathHelper;
import org.apache.camel.kafkaconnector.common.services.kafkaconnect.KafkaConnectPropertyFactory;

class DefaultKafkaConnectPropertyFactory
implements KafkaConnectPropertyFactory {
    private final String bootstrapServer;

    public DefaultKafkaConnectPropertyFactory(String bootstrapServer) {
        this.bootstrapServer = bootstrapServer;
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServer);
        props.put("key.converter", "org.apache.kafka.connect.json.JsonConverter");
        props.put("value.converter", "org.apache.kafka.connect.json.JsonConverter");
        props.put("offset.storage.file.filename", this.getClass().getResource("/").getPath() + "connect.offsets");
        props.put("offset.flush.interval.ms", "10000");
        props.put("listeners", "http://localhost:9999");
        String pluginPaths = PluginPathHelper.getInstance().pluginPaths();
        props.put("plugin.path", pluginPaths);
        return props;
    }
}

