/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common.test;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.camel.kafkaconnector.common.clients.kafka.KafkaClient;
import org.apache.camel.kafkaconnector.common.test.TestMessageProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestMessageProducer<T>
implements TestMessageProducer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestMessageProducer.class);
    private final KafkaClient<String, T> kafkaClient;
    private final String topicName;
    private final int count;

    public AbstractTestMessageProducer(KafkaClient<String, T> kafkaClient, String topicName, int count) {
        this.kafkaClient = kafkaClient;
        this.topicName = topicName;
        this.count = count;
    }

    public AbstractTestMessageProducer(String bootstrapServer, String topicName, int count) {
        this.kafkaClient = new KafkaClient(bootstrapServer);
        this.topicName = topicName;
        this.count = count;
    }

    @Override
    public void produceMessages() throws ExecutionException, InterruptedException {
        LOG.trace("Producing messages ...");
        for (int i = 0; i < this.count; ++i) {
            Object message = this.testMessageContent(i);
            Map<String, String> headers = this.messageHeaders(message, i);
            if (headers == null) {
                this.kafkaClient.produce(this.topicName, message);
                continue;
            }
            this.kafkaClient.produce(this.topicName, message, headers);
        }
    }
}

