/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common;

import java.util.Properties;
import org.apache.camel.kafkaconnector.common.ConnectorPropertyFactory;

public class IdempotencyConfigBuilder<T extends ConnectorPropertyFactory> {
    private final T handle;
    private final Properties properties;

    public IdempotencyConfigBuilder(T handle, Properties properties) {
        this.handle = handle;
        this.properties = properties;
        this.withEnabled(true);
    }

    private IdempotencyConfigBuilder<T> withEntry(String key, Object value) {
        this.properties.put("camel.idempotency." + key, value);
        return this;
    }

    public IdempotencyConfigBuilder<T> withEnabled(boolean value) {
        return this.withEntry("enabled", value);
    }

    public IdempotencyConfigBuilder<T> withRepositoryType(String value) {
        return this.withEntry("repository.type", value);
    }

    public IdempotencyConfigBuilder<T> withExpressionType(String value) {
        return this.withEntry("expression.type", value);
    }

    public IdempotencyConfigBuilder<T> withExpressionHeader(String value) {
        return this.withEntry("expression.header", value);
    }

    public IdempotencyConfigBuilder<T> withMemoryDimension(String value) {
        return this.withEntry("memory.dimension", value);
    }

    public IdempotencyConfigBuilder<T> withKafkaTopic(String value) {
        return this.withEntry("kafka.topic", value);
    }

    public IdempotencyConfigBuilder<T> withKafkaBootstrapServers(String value) {
        return this.withEntry("kafka.bootstrap.servers", value);
    }

    public IdempotencyConfigBuilder<T> withKafkaMaxCacheSize(String value) {
        return this.withEntry("kafka.max.cache.size", value);
    }

    public IdempotencyConfigBuilder<T> withKafkaPollDurationMs(String value) {
        return this.withEntry("kafka.poll.duration.ms", value);
    }

    public T end() {
        return this.handle;
    }
}

