/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common.utils;

import java.io.IOException;
import java.net.ConnectException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkUtils {
    public static final int DEFAULT_ENDING_PORT = 65535;
    public static final int DEFAULT_STARTING_PORT = 49152;
    public static int freeStartingPort = 49152;
    private static final Logger LOG = LoggerFactory.getLogger(NetworkUtils.class);

    private NetworkUtils() {
    }

    public static int getFreePort() {
        return NetworkUtils.getFreePort(NetworkUtils.getHostname());
    }

    public static int getFreePort(String host) {
        return NetworkUtils.getFreePort(host, freeStartingPort, 65535);
    }

    public static int getFreePort(String host, Protocol protocol) {
        return NetworkUtils.getFreePort(host, freeStartingPort, 65535, protocol);
    }

    public static int getFreePort(String host, int startingPort, int endingPort) {
        return NetworkUtils.getFreePort(host, startingPort, endingPort, Protocol.TCP);
    }

    public static synchronized int getFreePort(String host, int startingPort, int endingPort, Protocol protocol) {
        int freePort = 0;
        for (int i = startingPort; i <= endingPort; ++i) {
            boolean found = NetworkUtils.checkPort(host, i, protocol);
            if (!found) continue;
            freePort = i;
            break;
        }
        return freePort;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkPort(String host, int port, Protocol protocol) {
        try {
            switch (protocol.ordinal()) {
                case 1: {
                    try (ServerSocket ss = new ServerSocket();){
                        ss.setReuseAddress(true);
                        ss.bind(new InetSocketAddress(host, port), 1);
                        ss.getLocalPort();
                        if (port == freeStartingPort) {
                            ++freeStartingPort;
                        }
                        boolean bl = true;
                        return bl;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                case 0: {
                    new DatagramSocket(new InetSocketAddress(host, port)).close();
                    if (port != freeStartingPort) return true;
                    ++freeStartingPort;
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean portIsOpen(String host, int port) {
        boolean bl;
        Socket socket = new Socket(host, port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnknownHostException e) {
                LOG.warn("Unknown host: {}", (Object)host);
                return false;
            }
            catch (IOException e) {
                if (e instanceof ConnectException) {
                    LOG.info("Port {} is likely closed: {}", (Object)port, (Object)e.getMessage());
                } else {
                    LOG.warn("Unhandled I/O exception: {}", (Object)e.getMessage(), (Object)e);
                }
                return false;
            }
        }
        socket.close();
        return bl;
    }

    public static String getHostname() {
        return "localhost";
    }

    public static String getAddress(String protocol) {
        return String.format("%s://%s:%d", protocol, NetworkUtils.getHostname(), NetworkUtils.getFreePort());
    }

    public static String getAddress(String protocol, int port) {
        return String.format("%s://%s:%d", protocol, NetworkUtils.getHostname(), port);
    }

    public static enum Protocol {
        UDP,
        TCP;

    }
}

