/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.org.apache.commons.io.DirectoryWalker;

public final class PluginPathHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PluginPathHelper.class);
    private static PluginPathHelper instance;
    private volatile List<String> connectors;

    private PluginPathHelper() {
    }

    private List<String> findPluginPaths() {
        ArrayList<String> pluginPaths = new ArrayList<String>();
        for (String module : this.connectors) {
            String path = System.getProperty("project.basedir") + File.separator + module;
            File pathFile = new File(path);
            try {
                LOG.debug("Base dir used for search: {}, with path: {}, coming from components: {}, {}, {}", new Object[]{pathFile.getCanonicalPath(), path, System.getProperty("project.basedir"), File.separator, module});
            }
            catch (IOException e) {
                LOG.error("I/O exception: {}", (Object)e.getMessage(), (Object)e);
            }
            PluginWalker pluginWalker = new PluginWalker();
            pluginPaths.addAll(pluginWalker.findPlugins(pathFile));
        }
        return pluginPaths;
    }

    public String pluginPaths() {
        String ret = String.join((CharSequence)",", this.findPluginPaths());
        LOG.info("Returning the following directories for the plugin path: {}", (Object)ret);
        return ret;
    }

    public void registerConnector(String[] connectorNames) {
        this.connectors = Stream.of(connectorNames).map(connectorName -> "connectors" + File.separator + connectorName).collect(Collectors.toList());
    }

    public static PluginPathHelper getInstance() {
        if (instance == null) {
            instance = new PluginPathHelper();
        }
        return instance;
    }

    private static class PluginWalker
    extends DirectoryWalker<String> {
        public PluginWalker() {
            super(null, 2);
        }

        protected void handleFile(File file, int depth, Collection<String> results) throws IOException {
            String parentDir;
            String fileName = file.getName();
            if (fileName.endsWith(".jar") && fileName.contains("kafka-connector") && fileName.contains("camel") && (parentDir = file.getParentFile().getCanonicalPath()).endsWith("target")) {
                LOG.debug("Adding directory (1): {}: {}", (Object)depth, (Object)parentDir);
                results.add(parentDir);
            }
        }

        protected boolean handleDirectory(File directory, int depth, Collection<String> results) throws IOException {
            String directoryName = directory.getName();
            if (directoryName.equals("target")) {
                String pluginDir = directory.getCanonicalPath();
                LOG.debug("Adding directory (2): {}: {}", (Object)depth, (Object)pluginDir);
                results.add(pluginDir);
            }
            return true;
        }

        public List<String> findPlugins(File startDir) {
            ArrayList<String> results = new ArrayList<String>();
            try {
                this.walk(startDir, results);
            }
            catch (IOException e) {
                LOG.error("I/O error while traversing candidate plugin dirs: {}", (Object)e.getMessage(), (Object)e);
            }
            return results;
        }
    }
}

