/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common.test;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.kafkaconnector.common.clients.kafka.KafkaClient;
import org.apache.camel.kafkaconnector.common.test.TestMessageConsumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestMessageConsumer<T>
implements TestMessageConsumer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestMessageConsumer.class);
    protected final KafkaClient<String, T> kafkaClient;
    protected final String topicName;
    private final int count;
    private final List<ConsumerRecord<String, T>> receivedMessages;
    private volatile int received;

    public AbstractTestMessageConsumer(KafkaClient<String, T> kafkaClient, String topicName, int count) {
        this.kafkaClient = kafkaClient;
        this.topicName = topicName;
        this.count = count;
        this.receivedMessages = new ArrayList<ConsumerRecord<String, T>>(count);
    }

    public boolean checkRecord(ConsumerRecord<String, T> record) {
        LOG.debug("Received: {}", record.value());
        ++this.received;
        this.receivedMessages.add(record);
        return this.received != this.count;
    }

    @Override
    public void consumeMessages() {
        this.kafkaClient.consume(this.topicName, this::checkRecord);
    }

    @Override
    public List<ConsumerRecord<String, T>> consumedMessages() {
        return this.receivedMessages;
    }
}

