/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.ssh.source;

import java.util.concurrent.ExecutionException;
import org.apache.camel.kafkaconnector.common.ConnectorPropertyFactory;
import org.apache.camel.kafkaconnector.common.test.CamelSourceTestSupport;
import org.apache.camel.kafkaconnector.common.test.TestMessageConsumer;
import org.apache.camel.kafkaconnector.ssh.services.SshService;
import org.apache.camel.kafkaconnector.ssh.services.SshServiceFactory;
import org.apache.camel.kafkaconnector.ssh.source.CamelSshPropertyFactory;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisabledIfSystemProperty(named="kafka.instance.type", matches="local-(kafka|strimzi)-container", disabledReason="Hangs when running with the embedded Kafka Connect instance")
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class CamelSourceSshITCase
extends CamelSourceTestSupport {
    @RegisterExtension
    public static SshService sshService = SshServiceFactory.createService();
    private final int expect = 1;
    private String oldUserHome = System.getProperty("user.home");

    protected String[] getConnectorsInTest() {
        return new String[]{"camel-ssh-kafka-connector"};
    }

    @BeforeAll
    public void setupKeyHome() {
        System.setProperty("user.home", "target/user-home");
    }

    @AfterAll
    public void tearDownKeyHome() {
        System.setProperty("user.home", this.oldUserHome);
    }

    protected void produceTestData() {
    }

    protected void verifyMessages(TestMessageConsumer<?> consumer) {
        int received = consumer.consumedMessages().size();
        Assertions.assertEquals((int)received, (int)1, (String)"Didn't process the expected amount of messages");
    }

    @Timeout(value=90L)
    @Test
    public void testRetrieveFromSsh() throws ExecutionException, InterruptedException {
        String topic = this.getTopicForTest((Object)this);
        ConnectorPropertyFactory connectorPropertyFactory = ((CamelSshPropertyFactory)CamelSshPropertyFactory.basic().withKafkaTopic(topic)).withHost(sshService.getSshHost()).withPort(Integer.toString(sshService.getSshPort())).withDelay(Integer.toString(10000)).withUsername("root").withPassword("root").withPollcommand("date").withTransformsConfig("SshTransforms").withEntry("type", "org.apache.camel.kafkaconnector.ssh.transformers.SshTransforms").end();
        this.runTest(connectorPropertyFactory, topic, 1);
    }
}

