/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.ssh.sink;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.camel.kafkaconnector.common.AbstractKafkaTest;
import org.apache.camel.kafkaconnector.common.ConnectorPropertyFactory;
import org.apache.camel.kafkaconnector.common.clients.kafka.KafkaClient;
import org.apache.camel.kafkaconnector.common.utils.TestUtils;
import org.apache.camel.kafkaconnector.ssh.services.SshService;
import org.apache.camel.kafkaconnector.ssh.services.SshServiceFactory;
import org.apache.camel.kafkaconnector.ssh.sink.CamelSshPropertyFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class CamelSinkSshITCase
extends AbstractKafkaTest {
    @RegisterExtension
    public static SshService sshService = SshServiceFactory.createService();
    private static final Logger LOG = LoggerFactory.getLogger(CamelSinkSshITCase.class);
    private final int expect = 3;

    protected String[] getConnectorsInTest() {
        return new String[]{"camel-ssh-kafka-connector"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putRecords(CountDownLatch latch) {
        KafkaClient kafkaClient = new KafkaClient(this.getKafkaService().getBootstrapServers());
        try {
            for (int i = 0; i < 3; ++i) {
                try {
                    kafkaClient.produce(TestUtils.getDefaultTestTopic(((Object)((Object)this)).getClass()), (Object)"date");
                    continue;
                }
                catch (ExecutionException e) {
                    LOG.error("Unable to produce messages: {}", (Object)e.getMessage(), (Object)e);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        finally {
            latch.countDown();
        }
    }

    public void runTest(ConnectorPropertyFactory connectorPropertyFactory) throws ExecutionException, InterruptedException {
        connectorPropertyFactory.log();
        this.getKafkaConnectService().initializeConnector(connectorPropertyFactory);
        CountDownLatch latch = new CountDownLatch(1);
        ExecutorService service = Executors.newCachedThreadPool();
        service.submit(() -> this.putRecords(latch));
        if (!latch.await(30L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Timed out wait for data to be added to the Kafka cluster");
        }
    }

    @Timeout(value=90L)
    @Test
    public void testSshCommand() throws ExecutionException, InterruptedException {
        String topic = TestUtils.getDefaultTestTopic(((Object)((Object)this)).getClass());
        CamelSshPropertyFactory connectorPropertyFactory = ((CamelSshPropertyFactory)CamelSshPropertyFactory.basic().withTopics(topic)).withHost(sshService.getSshHost()).withPort(Integer.toString(sshService.getSshPort())).withUsername("root").withPassword("root");
        this.runTest((ConnectorPropertyFactory)connectorPropertyFactory);
    }
}

