/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.ssh.source;

import java.util.concurrent.ExecutionException;
import org.apache.camel.kafkaconnector.common.AbstractKafkaTest;
import org.apache.camel.kafkaconnector.common.ConnectorPropertyFactory;
import org.apache.camel.kafkaconnector.common.clients.kafka.KafkaClient;
import org.apache.camel.kafkaconnector.common.utils.TestUtils;
import org.apache.camel.kafkaconnector.ssh.services.SshService;
import org.apache.camel.kafkaconnector.ssh.services.SshServiceFactory;
import org.apache.camel.kafkaconnector.ssh.source.CamelSshPropertyFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelSourceSshITCase
extends AbstractKafkaTest {
    @RegisterExtension
    public static SshService sshService = SshServiceFactory.createService();
    private static final Logger LOG = LoggerFactory.getLogger(CamelSourceSshITCase.class);
    private final int expect = 1;
    private int received;

    protected String[] getConnectorsInTest() {
        return new String[]{"camel-ssh-kafka-connector"};
    }

    private <T> boolean checkRecord(ConsumerRecord<String, T> record) {
        LOG.debug("Received: {}", record.value());
        ++this.received;
        return false;
    }

    public void runTest(ConnectorPropertyFactory connectorPropertyFactory) throws ExecutionException, InterruptedException {
        connectorPropertyFactory.log();
        this.getKafkaConnectService().initializeConnector(connectorPropertyFactory);
        LOG.debug("Creating the consumer ...");
        KafkaClient kafkaClient = new KafkaClient(this.getKafkaService().getBootstrapServers());
        kafkaClient.consume(TestUtils.getDefaultTestTopic(((Object)((Object)this)).getClass()), this::checkRecord);
        LOG.debug("Created the consumer ...");
        Assertions.assertEquals((int)this.received, (int)1, (String)"Didn't process the expected amount of messages");
    }

    @Timeout(value=90L)
    @Test
    public void testRetrieveFromSsh() throws ExecutionException, InterruptedException {
        String topic = TestUtils.getDefaultTestTopic(((Object)((Object)this)).getClass());
        ConnectorPropertyFactory connectorPropertyFactory = ((CamelSshPropertyFactory)CamelSshPropertyFactory.basic().withKafkaTopic(topic)).withHost(sshService.getSshHost()).withPort(Integer.toString(sshService.getSshPort())).withDelay(Integer.toString(10000)).withUsername("root").withPassword("root").withPollcommand("date").withTransformsConfig("SshTransforms").withEntry("type", "org.apache.camel.kafkaconnector.ssh.transformers.SshTransforms").end();
        this.runTest(connectorPropertyFactory);
    }
}

