/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.ssh.sink;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.kafkaconnector.common.ConnectorPropertyFactory;
import org.apache.camel.kafkaconnector.common.test.CamelSinkTestSupport;
import org.apache.camel.kafkaconnector.common.test.StringMessageProducer;
import org.apache.camel.kafkaconnector.common.test.TestMessageProducer;
import org.apache.camel.kafkaconnector.ssh.services.SshService;
import org.apache.camel.kafkaconnector.ssh.services.SshServiceFactory;
import org.apache.camel.kafkaconnector.ssh.sink.CamelSshPropertyFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled(value="Sink ssh kamelet needs to be implemented see: https://github.com/apache/camel-kamelets/issues/504")
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class CamelSinkSshITCase
extends CamelSinkTestSupport {
    @RegisterExtension
    public static SshService sshService = SshServiceFactory.createService();
    private static final Logger LOG = LoggerFactory.getLogger(CamelSinkSshITCase.class);
    private final int expect = 3;
    private String topic;

    protected String[] getConnectorsInTest() {
        return new String[]{"camel-ssh-sink-kafka-connector"};
    }

    @BeforeEach
    public void setUp() {
        this.topic = this.getTopicForTest((Object)this);
    }

    protected void consumeMessages(CountDownLatch latch) {
        latch.countDown();
    }

    protected void verifyMessages(CountDownLatch latch) throws InterruptedException {
        if (!latch.await(30L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Timed out wait for data to be added to the Kafka cluster");
        }
    }

    @Timeout(value=90L)
    @Test
    public void testSshCommand() throws Exception {
        CamelSshPropertyFactory connectorPropertyFactory = ((CamelSshPropertyFactory)CamelSshPropertyFactory.basic().withTopics(this.topic)).withHost(sshService.getSshHost()).withPort(Integer.toString(sshService.getSshPort())).withUsername("root").withPassword("root");
        this.runTestNonBlocking((ConnectorPropertyFactory)connectorPropertyFactory, (TestMessageProducer)new CustomProducer(this.getKafkaService().getBootstrapServers(), this.topic, 3));
    }

    private static class CustomProducer
    extends StringMessageProducer {
        public CustomProducer(String bootstrapServer, String topicName, int count) {
            super(bootstrapServer, topicName, count);
        }

        public String testMessageContent(int current) {
            return "date";
        }
    }
}

