/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.ssh.services;

import org.apache.camel.kafkaconnector.ssh.services.SshLocalContainerService;
import org.apache.camel.kafkaconnector.ssh.services.SshRemoteService;
import org.apache.camel.kafkaconnector.ssh.services.SshService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SshServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SshServiceFactory.class);

    private SshServiceFactory() {
    }

    public static SshService createService() {
        String instanceType = System.getProperty("ssh.instance.type");
        if (instanceType == null || instanceType.equals("local-ssh-container")) {
            return new SshLocalContainerService();
        }
        if (instanceType.equals("remote")) {
            return new SshRemoteService();
        }
        LOG.error("ssh instance must be one of 'local-ssh-container' or 'remote");
        throw new UnsupportedOperationException(String.format("Invalid rabbitmq instance type: %s", instanceType));
    }
}

