/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.ssh.services;

import org.apache.camel.kafkaconnector.ssh.services.SshContainer;
import org.apache.camel.kafkaconnector.ssh.services.SshService;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshLocalContainerService
implements SshService,
ContainerService<SshContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(SshLocalContainerService.class);
    private SshContainer container = new SshContainer();

    @Override
    public int getSshPort() {
        return this.container.getSSHPort();
    }

    @Override
    public String getSshHost() {
        return this.container.getSSHHost();
    }

    public void registerProperties() {
        System.setProperty("ssh.port", String.valueOf(this.getSshPort()));
        System.setProperty("ssh.host", this.getSshHost());
    }

    public void initialize() {
        this.container.start();
        LOG.info("SSH server running at address {}", (Object)this.getSshEndpoint());
    }

    public void shutdown() {
        LOG.info("Stopping the Ssh container");
        this.container.stop();
    }

    public SshContainer getContainer() {
        return this.container;
    }
}

