/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.components;

import com.vaadin.ui.Accordion;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import eu.livotov.tpt.gui.windows.TPTWindow;
import java.util.HashMap;
import java.util.Map;
import org.apertereports.common.ReportConstants;
import org.apertereports.components.HelpWindow;
import org.apertereports.util.VaadinUtil;

public class HelpWindow
extends TPTWindow {
    private TabSheet tabs;

    public HelpWindow(Module module, Tab tab) {
        super(VaadinUtil.getValue((String)("help_window." + module.toString().toLowerCase() + ".title")));
        this.setWidth("40%");
        this.setHeight("80%");
        this.setModal(true);
        this.tabs = new TabSheet();
        HashMap<Tab, Component> tabContent = new HashMap<Tab, Component>();
        if (Module.MANAGER.equals((Object)module)) {
            tabContent.put(Tab.PARAMS, this.getReportParametersTab());
            tabContent.put(Tab.TEMPLATE_OPTIONS, this.getTemplatesOptionsTab());
        } else if (Module.DASHBOARD.equals((Object)module)) {
            tabContent.put(Tab.REPORT_DETAILS, this.getReportDetailsTab());
            tabContent.put(Tab.EDIT_REPORT, this.getEditReportTab());
            tabContent.put(Tab.CYCLIC_REPORTS, this.getCyclicReportsTab());
        }
        for (Map.Entry comp : tabContent.entrySet()) {
            this.tabs.addTab((Component)comp.getValue());
            this.tabs.getTab((Component)comp.getValue()).setCaption(VaadinUtil.getValue((String)("help_window.tabs." + ((Tab)comp.getKey()).toString().toLowerCase() + ".title")));
        }
        this.tabs.setSelectedTab((Component)tabContent.get(tab));
        this.addComponent((Component)this.tabs);
    }

    public void escapeKeyPressed() {
        this.close();
    }

    private Component getReportParametersTab() {
        VerticalLayout vl = new VerticalLayout();
        vl.addComponent((Component)new Label(VaadinUtil.getValue((String)("help_window.tabs." + Tab.PARAMS.toString().toLowerCase() + ".intro")), 3));
        Accordion accordion = new Accordion();
        for (ReportConstants.Keys param : ReportConstants.Keys.values()) {
            String title = VaadinUtil.getValue((String)("help_window.tabs." + Tab.PARAMS.toString().toLowerCase() + "." + param.toString().toLowerCase() + ".title"), (Object[])new Object[]{param.toString().toLowerCase()}) + " - " + param.toString().toLowerCase();
            String property_name = VaadinUtil.getValue((String)("help_window.tabs." + Tab.PARAMS.toString().toLowerCase() + ".param_name"), (Object[])new Object[]{param.toString().toLowerCase()});
            String property_desc = VaadinUtil.getValue((String)("help_window.tabs." + Tab.PARAMS.toString().toLowerCase() + "." + param.toString().toLowerCase() + ".content"), (Object[])new Object[]{param.toString().toLowerCase()});
            Label content = new Label(property_name + "<br/>" + property_desc, 3);
            accordion.addTab((Component)content, title, null);
        }
        vl.addComponent((Component)accordion);
        accordion.setSelectedTab((Component)new Label());
        return vl;
    }

    private Component getTemplatesOptionsTab() {
        return this.getSimpleHelpTab(Tab.TEMPLATE_OPTIONS.toString().toLowerCase());
    }

    private Component getReportDetailsTab() {
        return this.getSimpleHelpTab(Tab.REPORT_DETAILS.toString().toLowerCase());
    }

    private Component getEditReportTab() {
        return this.getSimpleHelpTab(Tab.EDIT_REPORT.toString().toLowerCase());
    }

    private Component getCyclicReportsTab() {
        return this.getSimpleHelpTab(Tab.CYCLIC_REPORTS.toString().toLowerCase());
    }

    private Component getSimpleHelpTab(String infix) {
        VerticalLayout vl = new VerticalLayout();
        vl.setSpacing(true);
        vl.addComponent((Component)new Label(VaadinUtil.getValue((String)("help_window.tabs." + infix + ".intro")), 3));
        vl.addComponent((Component)new Label(VaadinUtil.getValue((String)("help_window.tabs." + infix + ".content")), 3));
        return vl;
    }
}

