/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.components;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.IndexedContainer;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.DateField;
import com.vaadin.ui.Field;
import com.vaadin.ui.Form;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Select;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apertereports.components.ReportOrderBrowserComponent;
import org.apertereports.dao.ReportOrderDAO;
import org.apertereports.dao.ReportTemplateDAO;
import org.apertereports.generators.ReportOrderColumnGenerator;
import org.apertereports.model.ReportOrder;
import org.apertereports.model.ReportTemplate;
import org.apertereports.util.VaadinUtil;

public class ReportOrderBrowserComponent
extends CustomComponent
implements Serializable {
    private static final long serialVersionUID = 384175771652213854L;
    private final Columns[] visibleCols = new Columns[]{Columns.REPORT_NAME, Columns.CREATE_DATE, Columns.RESULT, Columns.DETAILS, Columns.ACTION};
    private final VerticalLayout filterBox = new VerticalLayout();
    private Panel mainLayout;
    private final Table reportOrderTable = new Table();
    private IndexedContainer reportTableData;
    private Collection<ReportTemplate> reportTemplates;
    private Collection<ReportOrder> allReportOrders;
    private Select reportOrderSelect;
    private DateField createdAfter;
    private DateField createdBefore;

    public ReportOrderBrowserComponent() {
        this.buildMainLayout();
        this.setCompositionRoot((Component)this.mainLayout);
        this.initFilteringControls();
        this.initReportTable();
    }

    private void addItems(IndexedContainer container, Integer reportId, Calendar createdAfter, Calendar createdBefore) {
        for (ReportOrder reportOrder : this.allReportOrders) {
            if (reportId != null && !reportId.equals(reportOrder.getReport().getId()) || createdAfter != null && !createdAfter.before(reportOrder.getCreateDate()) || createdBefore != null && !createdBefore.after(reportOrder.getCreateDate())) continue;
            Item item = container.addItem((Object)reportOrder.getId());
            item.getItemProperty((Object)Columns.REPORT_NAME).setValue((Object)reportOrder.getReport().getDescription());
            item.getItemProperty((Object)Columns.CREATE_DATE).setValue(reportOrder.getCreateDate() == null ? null : reportOrder.getCreateDate().getTime());
            item.getItemProperty((Object)Columns.REPORT_ORDER).setValue((Object)reportOrder);
            item.getItemProperty((Object)Columns.RESULT).setValue((Object)reportOrder.getReportStatus());
        }
    }

    private void buildMainLayout() {
        this.mainLayout = new Panel();
        this.mainLayout.setScrollable(true);
        this.mainLayout.setStyleName("borderless light");
        this.mainLayout.setSizeUndefined();
        this.mainLayout.addComponent((Component)this.filterBox);
        this.mainLayout.addComponent((Component)this.reportOrderTable);
    }

    private void initFilteringControls() {
        Form form = new Form();
        this.reportOrderSelect = new Select(VaadinUtil.getValue((String)"report_order.filter.report"));
        this.reportOrderSelect.setNullSelectionAllowed(true);
        this.reportTemplates = ReportTemplateDAO.fetchAllReports((boolean)true);
        for (ReportTemplate reportTemplate : this.reportTemplates) {
            if (reportTemplate == null || StringUtils.isEmpty((String)reportTemplate.getDescription())) continue;
            this.reportOrderSelect.addItem((Object)reportTemplate.getId());
            this.reportOrderSelect.setItemCaption((Object)reportTemplate.getId(), reportTemplate.getReportname() + " (" + reportTemplate.getDescription() + ")");
        }
        this.reportOrderSelect.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        form.addField((Object)"report_order_select", (Field)this.reportOrderSelect);
        Calendar threeDaysAgo = Calendar.getInstance();
        threeDaysAgo.add(5, -3);
        this.createdAfter = new DateField(VaadinUtil.getValue((String)"report_order.filter.created_after"));
        this.createdAfter.setResolution(2);
        this.createdAfter.setValue((Object)threeDaysAgo.getTime());
        this.createdAfter.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        form.addField((Object)"created_after", (Field)this.createdAfter);
        this.createdBefore = new DateField(VaadinUtil.getValue((String)"report_order.filter.created_before"));
        this.createdBefore.setResolution(2);
        this.createdBefore.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        form.addField((Object)"created_before", (Field)this.createdBefore);
        form.setImmediate(true);
        this.filterBox.addComponent((Component)form);
        Button refreshButton = new Button(VaadinUtil.getValue((String)"report_order.table.refresh"));
        refreshButton.setImmediate(true);
        refreshButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.filterBox.addComponent((Component)refreshButton);
    }

    private void initReportTable() {
        this.reportTableData = this.prepareData();
        this.reportOrderTable.setContainerDataSource((Container)this.reportTableData);
        this.reportOrderTable.addGeneratedColumn((Object)Columns.RESULT, (Table.ColumnGenerator)new ReportOrderColumnGenerator());
        this.reportOrderTable.addGeneratedColumn((Object)Columns.DETAILS, (Table.ColumnGenerator)new ReportOrderColumnGenerator());
        this.reportOrderTable.addGeneratedColumn((Object)Columns.CREATE_DATE, (Table.ColumnGenerator)new ReportOrderColumnGenerator());
        this.reportOrderTable.addGeneratedColumn((Object)Columns.ACTION, (Table.ColumnGenerator)new ReportOrderColumnGenerator());
        this.reportOrderTable.setVisibleColumns((Object[])this.visibleCols);
        for (Columns col : this.visibleCols) {
            this.reportOrderTable.setColumnHeader((Object)col, VaadinUtil.getValue((String)("report_order.table.column." + StringUtils.lowerCase((String)col.toString()))));
        }
        this.filterItems();
    }

    private IndexedContainer prepareData() {
        IndexedContainer container = new IndexedContainer();
        container.addContainerProperty((Object)Columns.REPORT_NAME, String.class, null);
        container.addContainerProperty((Object)Columns.CREATE_DATE, Date.class, null);
        container.addContainerProperty((Object)Columns.REPORT_ORDER, ReportOrder.class, null);
        container.addContainerProperty((Object)Columns.RESULT, ReportOrder.Status.class, null);
        this.allReportOrders = ReportOrderDAO.fetchAllReportOrders();
        return container;
    }

    protected void filterItems() {
        Integer reportId = (Integer)this.reportOrderSelect.getValue();
        Calendar createdBeforeCal = null;
        if (this.createdBefore.getValue() != null) {
            createdBeforeCal = Calendar.getInstance();
            createdBeforeCal.setTime((Date)this.createdBefore.getValue());
        }
        Calendar createdAfterCal = null;
        if (this.createdAfter.getValue() != null) {
            createdAfterCal = Calendar.getInstance();
            createdAfterCal.setTime((Date)this.createdAfter.getValue());
        }
        this.reportTableData.removeAllItems();
        this.addItems(this.reportTableData, reportId, createdAfterCal, createdBeforeCal);
        this.reportOrderTable.setVisibleColumns((Object[])this.visibleCols);
    }

    protected void refresh() {
        this.allReportOrders = ReportOrderDAO.fetchAllReportOrders();
        this.filterItems();
    }
}

