/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.generators;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import eu.livotov.tpt.i18n.TM;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apertereports.common.ReportConstants;
import org.apertereports.components.ReportOrderBrowserComponent;
import org.apertereports.generators.ReportOrderColumnGenerator;
import org.apertereports.model.ReportOrder;
import org.apertereports.util.OnClickOpenMessageInNewWindow;
import org.apertereports.util.VaadinUtil;

public class ReportOrderColumnGenerator
implements Table.ColumnGenerator {
    public Component generateCell(Table source, Object itemId, Object columnId) {
        ReportOrder reportOrder = (ReportOrder)source.getItem(itemId).getItemProperty((Object)ReportOrderBrowserComponent.Columns.REPORT_ORDER).getValue();
        if (reportOrder == null) {
            return null;
        }
        switch (3.$SwitchMap$org$apertereports$components$ReportOrderBrowserComponent$Columns[((ReportOrderBrowserComponent.Columns)columnId).ordinal()]) {
            case 1: {
                if (reportOrder.getReportStatus() == ReportOrder.Status.SUCCEEDED) {
                    HorizontalLayout hl = new HorizontalLayout();
                    hl.setSpacing(true);
                    for (ReportConstants.ReportType format : ReportConstants.ReportType.values()) {
                        Button formatLink = new Button(format.toString());
                        formatLink.setStyleName("link");
                        formatLink.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                        hl.addComponent((Component)formatLink);
                    }
                    return hl;
                }
                if (reportOrder.getReportStatus() == ReportOrder.Status.PROCESSING) {
                    return new Label(VaadinUtil.getValue((String)"report_order.table.status.processing"));
                }
                if (reportOrder.getReportStatus() == ReportOrder.Status.FAILED) {
                    Button label = new Button(VaadinUtil.getValue((String)"report_order.table.status.failed"));
                    label.setStyleName("link");
                    label.setDescription(reportOrder.getErrorDetails());
                    label.addListener((Button.ClickListener)new OnClickOpenMessageInNewWindow((Component)source, TM.get((String)"report_order.table.status.failed.popup.title", (Object[])new Object[0]), reportOrder.getErrorDetails(), 1));
                    return label;
                }
                return new Label(VaadinUtil.getValue((String)"report_order.table.status.new"));
            }
            case 2: {
                Button paramsLink = new Button(VaadinUtil.getValue((String)"report_order.table.parameters"));
                paramsLink.setStyleName("link");
                paramsLink.addListener((Button.ClickListener)new OnClickOpenMessageInNewWindow((Component)source, TM.get((String)"report_order.table.parameters.popup.title", (Object[])new Object[0]), reportOrder.getParametersXml(), 1));
                return paramsLink;
            }
            case 3: {
                if (reportOrder.getReportStatus() != ReportOrder.Status.FAILED && reportOrder.getReportStatus() != ReportOrder.Status.SUCCEEDED) break;
                HorizontalLayout hl = new HorizontalLayout();
                hl.setSpacing(true);
                Button rerunLink = new Button(VaadinUtil.getValue((String)"report_order.table.rerun"));
                rerunLink.setStyleName("link");
                rerunLink.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                hl.addComponent((Component)rerunLink);
                return hl;
            }
            case 4: {
                Calendar createDateCal = reportOrder.getCreateDate();
                if (createDateCal == null) break;
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm");
                return new Label(sdf.format(createDateCal.getTime()));
            }
        }
        return null;
    }
}

