/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.util;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.event.FieldEvents;
import com.vaadin.terminal.ClassResource;
import com.vaadin.terminal.Resource;
import com.vaadin.ui.AbstractTextField;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import java.util.Arrays;
import java.util.Collection;
import org.apertereports.common.ReportConstants;
import org.apertereports.dao.ReportTemplateDAO;
import org.apertereports.model.ReportTemplate;
import org.apertereports.util.ComponentFactory;
import org.apertereports.util.VaadinUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ComponentFactory {
    private static final String SEARCH_FILTER_INPUT_PROMPT = "search-filter.input-prompt";
    private static final String REPORT_MANAGER_DATE_FORMAT = "report.manager.date.format";
    public static final String ICON_PATH = "/icons/16x16/";

    public static Label createLabel(Item item, String propertyId, String style, ComponentContainer parent) {
        Property property = item.getItemProperty((Object)propertyId);
        return ComponentFactory.createLabelByProperty((String)style, (ComponentContainer)parent, (Property)property);
    }

    public static Label createSimpleLabel(String valueKey, String style, ComponentContainer parent) {
        Label label = new Label(VaadinUtil.getValue((String)valueKey));
        label.setStyleName(style);
        if (parent != null) {
            parent.addComponent((Component)label);
        }
        label.setWidth(null);
        return label;
    }

    private static Label createLabelByProperty(String style, ComponentContainer parent, Property property) {
        Label label = new Label(property);
        label.setStyleName(style);
        if (parent != null) {
            parent.addComponent((Component)label);
        }
        label.setWidth(null);
        return label;
    }

    public static Button createButton(String captionCode, String style, ComponentContainer parent) {
        Button button = new Button(VaadinUtil.getValue((String)captionCode));
        button.setStyleName(style);
        if (parent != null) {
            parent.addComponent((Component)button);
        }
        return button;
    }

    public static Button createButton(String captionCode, String style, ComponentContainer container, Button.ClickListener listener) {
        Button button = ComponentFactory.createButton((String)captionCode, (String)style, (ComponentContainer)container);
        button.addListener(listener);
        return button;
    }

    public static Label createDateLabel(Item item, String propertyName, String style, ComponentContainer parent) {
        return ComponentFactory.createLabelByProperty((String)style, (ComponentContainer)parent, (Property)new DateProperty(item.getItemProperty((Object)propertyName)));
    }

    public static Label createCalendarLabel(Item item, String propertyName, String style, ComponentContainer parent) {
        return ComponentFactory.createLabelByProperty((String)style, (ComponentContainer)parent, (Property)new CalendarProperty(item.getItemProperty((Object)propertyName)));
    }

    public static CheckBox createCheckBox(String captionCode, Item item, String propertyId, ComponentContainer parent) {
        CheckBox checkBox = new CheckBox(VaadinUtil.getValue((String)captionCode), item.getItemProperty((Object)propertyId));
        if (parent != null) {
            parent.addComponent((Component)checkBox);
        }
        return checkBox;
    }

    public static TextArea createTextArea(Item item, String propertyId, String promptKey, ComponentContainer parent) {
        TextArea area = new TextArea(item.getItemProperty((Object)propertyId));
        area.setInputPrompt(VaadinUtil.getValue((String)promptKey));
        area.setWidth("100%");
        if (parent != null) {
            parent.addComponent((Component)area);
        }
        return area;
    }

    public static HorizontalLayout createHLayoutFull(ComponentContainer parent) {
        HorizontalLayout hLayout = ComponentFactory.createHLayout((ComponentContainer)parent);
        hLayout.setWidth("100%");
        return hLayout;
    }

    public static HorizontalLayout createHLayout(ComponentContainer parent) {
        HorizontalLayout hLayout = new HorizontalLayout();
        if (parent != null) {
            parent.addComponent((Component)hLayout);
        }
        hLayout.setSpacing(true);
        return hLayout;
    }

    public static TextField createSearchBox(FieldEvents.TextChangeListener listener, ComponentContainer parent) {
        TextField search = new TextField();
        search.setInputPrompt(VaadinUtil.getValue((String)"search-filter.input-prompt"));
        search.setWidth("100%");
        search.setImmediate(true);
        search.setTextChangeTimeout(500);
        search.setTextChangeEventMode(AbstractTextField.TextChangeEventMode.LAZY);
        search.addListener(listener);
        if (parent != null) {
            parent.addComponent((Component)search);
        }
        return search;
    }

    public static ComboBox createFormatCombo(ReportConstants.ReportType selectedValue, String captionKey) {
        BeanItemContainer all = new BeanItemContainer(String.class, Arrays.asList(ReportConstants.ReportType.stringValues()));
        ComboBox format = new ComboBox(VaadinUtil.getValue((String)captionKey), (Container)all);
        format.setValue((Object)selectedValue.name());
        format.setStyleName("small");
        format.setNullSelectionAllowed(false);
        format.setTextInputAllowed(false);
        return format;
    }

    public static ComboBox createReportTemplateCombo(ReportTemplate selectedValue, String captionKey) {
        Collection allReports = ReportTemplateDAO.fetchAllReports((boolean)true);
        ComboBox reports = new ComboBox(VaadinUtil.getValue((String)captionKey), (Container)new BeanItemContainer(ReportTemplate.class, allReports));
        reports.setItemCaptionPropertyId((Object)"reportname");
        reports.setValue((Object)selectedValue);
        reports.setTextInputAllowed(false);
        reports.setNullSelectionAllowed(false);
        return reports;
    }

    public static Embedded createIcon(Item item, String proprtyId, ComponentContainer parent) {
        Enum value = (Enum)item.getItemProperty((Object)proprtyId).getValue();
        Embedded icon = new Embedded(null, (Resource)new ClassResource(AperteIcons.getIconUrl((Enum)value), parent.getApplication()));
        icon.setDescription(value.getClass().getSimpleName() + ": " + value.name());
        parent.addComponent((Component)icon);
        return icon;
    }
}

