/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.codec.binary.Base64;
import org.apertereports.common.ReportConstants;
import org.apertereports.common.exception.AperteReportsException;
import org.apertereports.common.wrappers.Pair;
import org.apertereports.dao.utils.ConfigurationCache;
import org.apertereports.engine.ReportMaster;
import org.apertereports.model.ReportOrder;
import org.apertereports.util.DashboardUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DashboardUtil {
    public static final String CHART_SOURCE_PREFIX_REGEXP = "dashboardimage\\?image=";
    public static final String CHART_SOURCE_PREFIX_TEXT = "dashboardimage?image=";
    public static final Pattern REPORT_TAG_PATTERN = Pattern.compile("<REPORT\\sidx=\\\"([0-9]+)\\\"\\s?(xlsidx=\\\"([0-9]+)\\\")?\\s?[/]{0,1}>(?!</REPORT>)|<REPORT\\sidx=\\\"([0-9]+)\\\"\\s?(xlsidx=\\\"([0-9]+)\\\")?\\s?[/]{0,1}></REPORT>", 2);
    public static Pattern CHART_TAG_PATTERN = Pattern.compile("(<img\\s+src=\"dashboardimage\\?image=[^>]+?/>)|(<img\\s+src=\"dashboardimage\\?image=[^>]+?>.*</img>)", 2);
    public static final Pattern DRILLDOWN_TAG_PATTERN = Pattern.compile("(<a\\s+href=\"drilldown\\?reportName=[^>]+?/>)|(<a\\s+href=\"drilldown\\?reportName=[^>]+?>.*</a>)", 2);

    private DashboardUtil() {
    }

    public static Integer generateDrilldownId(Set<Integer> actualIds) {
        Integer maxId = 0;
        for (Integer id : actualIds) {
            if (maxId >= id) continue;
            maxId = id;
        }
        return maxId + 1;
    }

    public static Pair<String, Map<String, String>> parseHtmlTag(String tag, boolean spanStyle) throws Exception {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(new ByteArrayInputStream(tag.getBytes()));
        Element el = doc.getDocumentElement();
        String text = el.getTextContent();
        HashMap params = new HashMap();
        DashboardUtil.fillAttributes((Element)el, params);
        if (spanStyle) {
            NodeList children = el.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Element child;
                if (children.item(i).getNodeType() != 1 || !"span".equalsIgnoreCase((child = (Element)children.item(i)).getNodeName())) continue;
                DashboardUtil.fillAttributes((Element)child, params);
            }
        }
        return new Pair((Object)(text != null ? text : ""), params);
    }

    private static void fillAttributes(Element el, Map<String, String> params) {
        NamedNodeMap map = el.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Node node = map.item(i);
            params.put(node.getNodeName(), node.getNodeValue());
        }
    }

    public static Map<String, List<String>> parseHyperlinkParameters(String hyperlink) throws UnsupportedEncodingException {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        String[] urlParts = hyperlink.split("\\?");
        if (urlParts.length > 1) {
            String query = urlParts[1];
            for (String param : query.split("&")) {
                String[] pair = param.split("=");
                String key = URLDecoder.decode(pair[0], "UTF-8");
                String value = URLDecoder.decode(pair[1], "UTF-8");
                ArrayList<String> values = (ArrayList<String>)params.get(key);
                if (values == null) {
                    values = new ArrayList<String>();
                    params.put(key, values);
                }
                values.add(value);
            }
        }
        return params;
    }

    public static Set<Integer> getReportConfigIds(String template) {
        HashSet<Integer> configIds = new HashSet<Integer>();
        DashboardUtil.executeTemplateMatcherWithList((String)template, (Pattern)REPORT_TAG_PATTERN, (MatchHandlerWithList)new /* Unavailable Anonymous Inner Class!! */);
        return configIds;
    }

    public static void executeTemplateMatcher(String template, Pattern pattern, MatchHandler handler) {
        if (template != null && !template.isEmpty()) {
            Matcher m = pattern.matcher(template);
            while (m.find()) {
                String match = null;
                if (m.start(0) < m.end(0) && (match = m.group(1)) == null) {
                    match = m.group(0);
                }
                handler.handleMatch(m.start(0), m.end(0), match);
            }
        }
    }

    public static void executeTemplateMatcherWithList(String template, Pattern pattern, MatchHandlerWithList handler) {
        if (template != null && !template.isEmpty()) {
            Matcher m = pattern.matcher(template);
            while (m.find()) {
                LinkedList<String> matches = new LinkedList<String>();
                if (m.start(0) < m.end(0)) {
                    for (int i = 1; i <= m.groupCount(); ++i) {
                        if (m.group(i) == null) continue;
                        matches.add(m.group(i));
                    }
                }
                handler.handleMatch(m.start(0), m.end(0), matches);
            }
        }
    }

    public static byte[] exportReportOrderData(ReportOrder reportOrder, ReportConstants.ReportType format) throws AperteReportsException {
        JasperPrint jasperPrint;
        try {
            jasperPrint = (JasperPrint)JRLoader.loadObject((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)reportOrder.getReportResult())));
        }
        catch (JRException e) {
            throw new AperteReportsException((Throwable)e);
        }
        return ReportMaster.exportReport((JasperPrint)jasperPrint, (String)format.toString(), (Map)ConfigurationCache.getConfiguration());
    }
}

