/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.util.wrappers;

import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.ui.Component;
import com.vaadin.ui.Select;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apertereports.common.wrappers.DictionaryItem;
import org.apertereports.common.wrappers.DictionaryItemFilter;

public class FilterContainer
extends VerticalLayout {
    HashMap<Integer, Select> levels = new HashMap();
    private List<DictionaryItem> items;

    public void addFilter(Select select, Integer level, List<DictionaryItem> items) {
        this.addComponent((Component)select);
        this.levels.put(level, select);
        if (items != null) {
            this.items = items;
        }
        select.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fillEmptySelects(this.items);
    }

    public void addValidator(Validator validator) {
        ((Select)this.levels.get(0)).addValidator(validator);
    }

    public List<Select> getLevels() {
        ArrayList<Select> selects = new ArrayList<Select>(this.levels.size());
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            selects.add((Select)this.levels.get(i));
        }
        return selects;
    }

    public Object getValue() {
        return ((Select)this.levels.get(0)).getValue();
    }

    public void setValue(Object value) {
        ((Select)this.levels.get(0)).setValue(value);
    }

    public void validate() {
        ((Select)this.levels.get(0)).validate();
    }

    private void fillEmptySelects(List<DictionaryItem> filteredItems) {
        if (filteredItems != null) {
            for (Map.Entry entry : this.levels.entrySet()) {
                Integer key = (Integer)entry.getKey();
                Select value = (Select)entry.getValue();
                if (value.size() != 0) continue;
                for (DictionaryItem item : filteredItems) {
                    String itemId = key == 0 ? item.getColumn(Integer.valueOf(0)) : item.getColumn(Integer.valueOf(key + 1));
                    value.addItem((Object)itemId);
                    value.setItemCaption((Object)itemId, item.getColumn(Integer.valueOf(key + 1)));
                }
            }
        }
    }

    private List<DictionaryItem> filterItems(HashMap<Integer, Object> filterValues) {
        LinkedList<DictionaryItem> filteredItems = new LinkedList<DictionaryItem>();
        DictionaryItemFilter filter = new DictionaryItemFilter(this.levels.size() + 1, filterValues);
        for (DictionaryItem item : this.items) {
            if (!filter.appliesTo((Object)item)) continue;
            filteredItems.add(item);
        }
        return filteredItems;
    }

    protected void filterFields(Integer startLevel) {
        HashMap<Integer, Object> filterValues = new HashMap<Integer, Object>(this.levels.size());
        if (this.items != null) {
            for (Map.Entry entry : this.levels.entrySet()) {
                Integer key = (Integer)entry.getKey();
                Select value = (Select)entry.getValue();
                filterValues.put(key, value.getValue());
                if (key >= startLevel) continue;
                value.removeAllItems();
            }
        }
        List filteredItems = this.filterItems(filterValues);
        this.fillEmptySelects(filteredItems);
    }
}

