/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;
import com.vaadin.Application;
import com.vaadin.event.ListenerMethod;
import com.vaadin.terminal.Terminal;
import com.vaadin.terminal.gwt.server.PortletApplicationContext2;
import com.vaadin.ui.Window;
import eu.livotov.tpt.TPTApplication;
import eu.livotov.tpt.i18n.TM;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apertereports.common.exception.AperteReportsRuntimeException;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.util.NotificationUtil;

public abstract class AbstractReportingApplication
extends TPTApplication
implements PortletApplicationContext2.PortletListener {
    protected User user;
    protected Locale locale;

    public void applicationInit() {
        if (this.getContext() instanceof PortletApplicationContext2) {
            ((PortletApplicationContext2)this.getContext()).removePortletListener((Application)this, (PortletApplicationContext2.PortletListener)this);
            ((PortletApplicationContext2)this.getContext()).addPortletListener((Application)this, (PortletApplicationContext2.PortletListener)this);
        }
        TM.getDictionary().setDefaultLanguage(this.getLocale().getLanguage());
        this.reloadDictionary();
        this.portletInit();
    }

    protected abstract void portletInit();

    public void firstApplicationStartup() {
    }

    private void reloadDictionary() {
    }

    public void terminalError(Terminal.ErrorEvent event) {
        Throwable throwable = event.getThrowable();
        if (throwable instanceof Exception) {
            ExceptionUtils.logSevereException((Exception)((Exception)throwable));
        }
        if (throwable instanceof ListenerMethod.MethodException) {
            throwable = ((ListenerMethod.MethodException)throwable).getCause();
        }
        if (throwable instanceof AperteReportsRuntimeException) {
            AperteReportsRuntimeException vre = (AperteReportsRuntimeException)throwable;
            NotificationUtil.showExceptionNotification((Window)this.getMainWindow(), (AperteReportsRuntimeException)vre);
        } else {
            super.terminalError(event);
        }
    }

    public void handleRenderRequest(RenderRequest request, RenderResponse response, Window window) {
        if (this.getContext() instanceof PortletApplicationContext2) {
            try {
                this.user = PortalUtil.getUser((PortletRequest)request);
                this.locale = PortalUtil.getLocale((RenderRequest)request);
            }
            catch (PortalException e) {
                ExceptionUtils.logSevereException((Exception)((Object)e));
                throw new RuntimeException(e);
            }
            catch (SystemException e) {
                ExceptionUtils.logSevereException((Exception)((Object)e));
                throw new RuntimeException(e);
            }
        }
    }

    public void handleActionRequest(ActionRequest request, ActionResponse response, Window window) {
    }

    public void handleEventRequest(EventRequest request, EventResponse response, Window window) {
    }

    public void handleResourceRequest(ResourceRequest request, ResourceResponse response, Window window) {
    }

    public User getLiferayUser() {
        return this.user;
    }
}

