/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.components;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.util.Collection;
import org.apertereports.util.ComponentFactory;

public abstract class PaginatedPanelList<O, W extends Panel>
extends VerticalLayout {
    private static final String PAGINATED_LIST_BUTTON_NEXT = "paginated-list.button.next";
    private static final String PAGINATED_LIST_BUTTON_PREVIOUS = "paginated-list.button.previous";
    private String filter;
    private int pageSize;
    private int listSize;
    private int pageNumber;

    public PaginatedPanelList(int pageSize) {
        this.pageSize = pageSize;
    }

    protected abstract Collection<O> fetch(String var1, int var2, int var3);

    protected abstract W transform(O var1);

    protected abstract int getListSize(String var1);

    public void filter(String filter) {
        this.filter = filter;
        this.pageNumber = 0;
        this.listSize = this.getListSize(filter);
        this.refresh();
    }

    private void refresh() {
        Collection list = this.fetch(this.filter, this.calculateFirstResult(), this.pageSize);
        this.removeAllComponents();
        for (Object o : list) {
            this.addComponent((Component)this.transform(o));
        }
        if (this.listSize > this.pageSize) {
            this.addFooter();
        }
    }

    private int calculateFirstResult() {
        return this.pageNumber * this.pageSize;
    }

    private void addFooter() {
        HorizontalLayout hl = ComponentFactory.createHLayout((ComponentContainer)this);
        hl.setMargin(true, false, false, false);
        ComponentFactory.createButton((String)PAGINATED_LIST_BUTTON_PREVIOUS, (String)"link", (ComponentContainer)hl, (Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        for (int i = 0; i < this.countPages(); ++i) {
            int pageIndex = i;
            String caption = "" + (pageIndex + 1);
            if (pageIndex == this.pageNumber) {
                ComponentFactory.createSimpleLabel((String)caption, (String)"", (ComponentContainer)hl);
                continue;
            }
            ComponentFactory.createButton((String)caption, (String)"link", (ComponentContainer)hl, (Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        ComponentFactory.createButton((String)PAGINATED_LIST_BUTTON_NEXT, (String)"link", (ComponentContainer)hl, (Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showPage(int pageNumber) {
        if (this.hasPage(pageNumber)) {
            this.pageNumber = pageNumber;
        }
    }

    private void nextPage() {
        if (this.hasNext()) {
            ++this.pageNumber;
        }
        this.refresh();
    }

    private void previousPage() {
        if (this.hasPrevious()) {
            --this.pageNumber;
        }
        this.refresh();
    }

    private int countPages() {
        int count = this.listSize / this.pageSize + 1;
        if (this.listSize % this.pageSize == 0) {
            --count;
        }
        return count;
    }

    private boolean hasPage(int pageNumber) {
        return pageNumber > 0 && pageNumber < this.countPages() - 1;
    }

    private boolean hasPrevious() {
        return this.pageNumber > 0;
    }

    private boolean hasNext() {
        return this.pageNumber < this.countPages() - 1;
    }

    static /* synthetic */ void access$000(PaginatedPanelList x0) {
        x0.previousPage();
    }

    static /* synthetic */ void access$100(PaginatedPanelList x0, int x1) {
        x0.showPage(x1);
    }

    static /* synthetic */ void access$200(PaginatedPanelList x0) {
        x0.nextPage();
    }
}

