/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.components;

import com.liferay.portal.model.User;
import com.vaadin.data.Buffered;
import com.vaadin.data.Validator;
import com.vaadin.data.validator.RegexpValidator;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Form;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.OptionGroup;
import com.vaadin.ui.Select;
import com.vaadin.ui.TextField;
import com.vaadin.ui.Window;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang.StringUtils;
import org.apertereports.AbstractLazyLoaderComponent;
import org.apertereports.AbstractReportingApplication;
import org.apertereports.backbone.util.ReportTemplateProvider;
import org.apertereports.common.ReportConstants;
import org.apertereports.common.exception.AperteReportsException;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.common.utils.TextUtils;
import org.apertereports.common.utils.TimeUtils;
import org.apertereports.common.wrappers.DictionaryItem;
import org.apertereports.common.xml.config.ReportConfig;
import org.apertereports.common.xml.config.ReportConfigParameter;
import org.apertereports.components.ReportParametersComponent;
import org.apertereports.dao.DictionaryDAO;
import org.apertereports.engine.ReportMaster;
import org.apertereports.engine.ReportParameter;
import org.apertereports.engine.ReportProperty;
import org.apertereports.engine.SubreportProvider;
import org.apertereports.util.ComponentFactory;
import org.apertereports.util.NotificationUtil;
import org.apertereports.util.VaadinUtil;
import org.apertereports.util.wrappers.DictionaryItemsWrapper;
import org.apertereports.util.wrappers.FieldContainer;
import org.apertereports.util.wrappers.FieldProperties;
import org.apertereports.util.wrappers.FilterContainer;

public class ReportParametersComponent
extends AbstractLazyLoaderComponent {
    private Form form = new Form();
    private HashMap<String, FilterContainer> filters;
    private List<FieldContainer> fields = new LinkedList();
    private ComboBox format;
    private ReportMaster reportMaster;
    private String reportSource;
    private Integer cacheId;
    private List<ReportConfigParameter> reportParameters;
    private boolean includeReportFormat = true;
    private boolean readonly = false;

    public ReportParametersComponent(ReportMaster reportMaster) throws AperteReportsException {
        this.reportMaster = reportMaster;
        this.init();
    }

    public ReportParametersComponent(String reportSource, Integer cacheId, boolean lazyLoad) throws AperteReportsException {
        this.reportSource = reportSource;
        this.cacheId = cacheId;
        if (!lazyLoad) {
            this.reportMaster = new ReportMaster(reportSource, cacheId.toString(), (SubreportProvider)new ReportTemplateProvider());
            this.init();
        }
    }

    public ReportParametersComponent(String reportSource, Integer cacheId, ReportConfig reportConfig, boolean includeReportFormat, boolean lazyLoad) throws AperteReportsException {
        this.reportSource = reportSource;
        this.cacheId = cacheId;
        this.reportParameters = reportConfig != null ? reportConfig.getParameters() : null;
        this.includeReportFormat = includeReportFormat;
        if (!lazyLoad) {
            this.reportMaster = new ReportMaster(reportSource, cacheId.toString(), (SubreportProvider)new ReportTemplateProvider());
            this.init();
        }
    }

    public ReportParametersComponent(String reportSource, Integer cacheId, List<ReportConfigParameter> reportParameters, boolean includeReportFormat, boolean lazyLoad, boolean readonly) throws AperteReportsException {
        this.reportSource = reportSource;
        this.cacheId = cacheId;
        this.reportParameters = reportParameters;
        this.includeReportFormat = includeReportFormat;
        this.readonly = readonly;
        if (!lazyLoad) {
            this.reportMaster = new ReportMaster(reportSource, cacheId.toString(), (SubreportProvider)new ReportTemplateProvider());
            this.init();
        }
    }

    public ReportParametersComponent(String reportSource, Integer cacheId, ReportConfig reportConfig, boolean includeReportFormat, boolean lazyLoad, boolean readonly) throws AperteReportsException {
        this.reportSource = reportSource;
        this.cacheId = cacheId;
        this.reportParameters = reportConfig != null ? reportConfig.getParameters() : null;
        this.includeReportFormat = includeReportFormat;
        this.readonly = readonly;
        if (!lazyLoad) {
            this.reportMaster = new ReportMaster(reportSource, cacheId.toString(), (SubreportProvider)new ReportTemplateProvider());
            this.init();
        }
    }

    public ReportParametersComponent(ReportMaster rm, boolean showFormat) throws AperteReportsException {
        this(rm);
        this.includeReportFormat = showFormat;
    }

    public Map<String, String> collectParametersValues() {
        HashMap<String, String> parameters = new HashMap<String, String>(this.fields.size());
        for (FieldContainer field : this.fields) {
            Object rawValue;
            if (field.getComponentType().equals((Object)ReportConstants.InputTypes.FILTER) || (rawValue = field.getValue()) == null) continue;
            String value = TextUtils.encodeObjectToSQL((Object)rawValue);
            parameters.put(field.getName(), value);
        }
        parameters.put("login", this.getLogin());
        return parameters;
    }

    private String getLogin() {
        String login = "";
        try {
            User user = ((AbstractReportingApplication)this.getApplication()).getLiferayUser();
            if (user == null || user.getEmailAddress() == null) {
                return login;
            }
            login = user.getLogin();
        }
        catch (Exception e) {
            ExceptionUtils.logWarningException((String)VaadinUtil.getValue((String)"liferay.get.login.exception"), (Exception)e);
            throw new RuntimeException(e);
        }
        if (login.contains("@")) {
            login = login.split("@", 2)[0];
        }
        return login;
    }

    public String getSelectedFormat() {
        return this.format != null ? this.format.getValue().toString() : null;
    }

    public void lazyLoad() throws Exception {
        this.reportMaster = new ReportMaster(this.reportSource, this.cacheId.toString(), (SubreportProvider)new ReportTemplateProvider());
        this.init();
    }

    public boolean validateForm() {
        boolean result = true;
        for (FieldContainer field : this.fields) {
            field.validate();
        }
        try {
            this.form.commit();
        }
        catch (Validator.InvalidValueException e) {
            ExceptionUtils.logSevereException((Exception)((Object)e));
            result = false;
        }
        catch (Buffered.SourceException e) {
            ExceptionUtils.logSevereException((Exception)((Object)e));
            result = false;
        }
        return result;
    }

    private FieldContainer buildField(ReportParameter param, FieldProperties fieldProperties) {
        try {
            Field field;
            FieldContainer container = new FieldContainer();
            List items = null;
            if (StringUtils.isNotEmpty((String)fieldProperties.getDictQuery())) {
                String login = this.getLogin();
                String dictQuery = fieldProperties.getDictQuery().replaceAll("\\$LOGIN", login);
                items = DictionaryDAO.fetchDictionary((String)dictQuery);
            }
            if (StringUtils.isNotEmpty((String)fieldProperties.getDictItemList())) {
                items = DictionaryDAO.readDictionaryFromString((String)fieldProperties.getDictItemList());
            }
            if ((field = this.buildFieldBaseForInputType(fieldProperties, items = this.executeSpecialDataQueryCode(fieldProperties, items), container)) != null && field instanceof Field) {
                this.applyAttributes(fieldProperties, container, field);
            }
            if (fieldProperties.getInputType() == ReportConstants.InputTypes.FILTERED_SELECT || fieldProperties.getInputType() == ReportConstants.InputTypes.FILTER) {
                FilterContainer filterContainer = this.getFilterContainer(fieldProperties.getFilterGroup());
                filterContainer.addFilter((Select)field, fieldProperties.getLevel(), items);
                container.setFieldComponent((Component)filterContainer);
            }
            this.attachSpecialValidators(fieldProperties, container);
            container.setComponentType(fieldProperties.getInputType());
            container.setOrder(fieldProperties.getOrder());
            container.setName(param.getName());
            return container;
        }
        catch (BuildingFailedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void applyAttributes(FieldProperties fieldProperties, FieldContainer container, Field field) {
        container.setFieldComponent((Component)field);
        if (StringUtils.isNotEmpty((String)fieldProperties.getWidth())) {
            field.setWidth(StringUtils.lowerCase((String)fieldProperties.getWidth()));
        }
        container.setSelectAll(fieldProperties.getSelectAll().booleanValue());
        if (fieldProperties.isRequired().booleanValue()) {
            field.setRequired(fieldProperties.isRequired().booleanValue());
            field.setRequiredError(VaadinUtil.getValue((String)fieldProperties.getRequiredError(), (Object[])new Object[]{fieldProperties.getCaption()}));
        }
        if (StringUtils.isNotEmpty((String)fieldProperties.getRegexp())) {
            field.addValidator((Validator)new RegexpValidator(fieldProperties.getRegexp(), VaadinUtil.getValue((String)fieldProperties.getRegexpError(), (Object[])new Object[]{fieldProperties.getCaption(), fieldProperties.getRegexp()})));
        }
        if (StringUtils.isNotEmpty((String)fieldProperties.getMaxchars()) && field instanceof TextField) {
            try {
                ((TextField)field).setMaxLength(Integer.valueOf(fieldProperties.getMaxchars()).intValue());
            }
            catch (NumberFormatException e) {
                ExceptionUtils.logSevereException((Exception)e);
            }
        }
    }

    protected void attachSpecialValidators(FieldProperties fieldProperties, FieldContainer container) throws BuildingFailedException {
        if (fieldProperties.getSei() != null && StringUtils.isNotEmpty((String)fieldProperties.getSpecialValidationCode())) {
            try {
                fieldProperties.getSe().eval(fieldProperties.getSpecialValidationCode());
                Validator validator = (Validator)fieldProperties.getSei().invokeFunction("specialValidator", container, fieldProperties.getSpecialValidationError());
                container.addValidator(validator);
            }
            catch (ScriptException e) {
                NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)"invoker.form.special_validation_code.script_exception", (Exception)e);
                ExceptionUtils.logSevereException((Exception)e);
                throw new BuildingFailedException(this, null);
            }
            catch (NoSuchMethodException e) {
                NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)"invoker.form.special_validation_code.no_such_method_exception", (Exception)e);
                ExceptionUtils.logSevereException((Exception)e);
                throw new BuildingFailedException(this, null);
            }
        }
    }

    protected Field buildFieldBaseForInputType(FieldProperties fieldProperties, List<DictionaryItem> items, FieldContainer container) throws BuildingFailedException {
        TextField field = null;
        switch (3.$SwitchMap$org$apertereports$common$ReportConstants$InputTypes[fieldProperties.getInputType().ordinal()]) {
            case 1: {
                field = new TextField(fieldProperties.getCaption());
                break;
            }
            case 2: {
                field = new CheckBox(fieldProperties.getCaption());
                break;
            }
            case 3: {
                1 dateField = new /* Unavailable Anonymous Inner Class!! */;
                dateField.setDateFormat(TimeUtils.getDefaultDateFormat());
                dateField.setResolution(2);
                field = dateField;
                break;
            }
            case 4: {
                TextField text = new TextField(fieldProperties.getCaption());
                text.setRows(3);
                field = text;
                break;
            }
            case 5: 
            case 6: {
                Select select = new Select(fieldProperties.getCaption());
                select.setImmediate(true);
                try {
                    for (DictionaryItem item : items) {
                        select.addItem((Object)item.getCode());
                        select.setItemCaption((Object)item.getCode(), item.getDescription());
                    }
                }
                catch (NullPointerException e) {
                    NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)"invoker.form.no_items_for_exception", (String)fieldProperties.getCaption());
                    throw new BuildingFailedException(this, null);
                }
                select.setMultiSelect(fieldProperties.getInputType() == ReportConstants.InputTypes.MULTISELECT);
                select.setFilteringMode(2);
                field = select;
                break;
            }
            case 7: 
            case 8: {
                OptionGroup optionGroup = new OptionGroup(fieldProperties.getCaption());
                try {
                    for (DictionaryItem item : items) {
                        optionGroup.addItem((Object)item.getCode());
                        optionGroup.setItemCaption((Object)item.getCode(), item.getDescription());
                    }
                }
                catch (NullPointerException e) {
                    NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)"invoker.form.no_items_for_exception", (String)fieldProperties.getCaption());
                    throw new BuildingFailedException(this, null);
                }
                optionGroup.setMultiSelect(fieldProperties.getInputType() == ReportConstants.InputTypes.CHECKBOXES);
                field = optionGroup;
                break;
            }
            case 9: 
            case 10: {
                Select filterSelect = new Select(fieldProperties.getCaption());
                filterSelect.setImmediate(true);
                filterSelect.setMultiSelect(fieldProperties.isMultipleChoice().booleanValue());
                field = filterSelect;
                break;
            }
            case 11: {
                Component component;
                if (fieldProperties.getSei() != null && StringUtils.isNotEmpty((String)fieldProperties.getSpecialControlCode())) {
                    try {
                        fieldProperties.getSe().eval(fieldProperties.getSpecialControlCode());
                        fieldProperties.getSei().invokeFunction("specialControl", container, items, fieldProperties.getWidth(), fieldProperties.getMaxchars(), fieldProperties.isRequired(), fieldProperties.getRequiredError(), fieldProperties.getRegexp(), fieldProperties.getRegexpError(), fieldProperties.getCaption());
                    }
                    catch (ScriptException e) {
                        NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)"invoker.form.special_control_code.script_exception", (Exception)e);
                        ExceptionUtils.logSevereException((Exception)e);
                        throw new BuildingFailedException(this, null);
                    }
                    catch (NoSuchMethodException e) {
                        NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)"invoker.form.special_control_code.no_such_method_exception", (Exception)e);
                        ExceptionUtils.logSevereException((Exception)e);
                        throw new BuildingFailedException(this, null);
                    }
                }
                if (!((component = container.getFieldComponent()) instanceof Field)) break;
                field = (Field)component;
                break;
            }
            default: {
                field = new TextField(fieldProperties.getCaption());
            }
        }
        return field;
    }

    public List<DictionaryItem> executeSpecialDataQueryCode(FieldProperties fieldProperties, List<DictionaryItem> items) throws BuildingFailedException {
        if (fieldProperties.getSei() != null && StringUtils.isNotEmpty((String)fieldProperties.getSpecialDataQueryCode())) {
            try {
                DictionaryItemsWrapper itemsWrapper = new DictionaryItemsWrapper();
                fieldProperties.getSe().eval(fieldProperties.getSpecialDataQueryCode());
                fieldProperties.getSei().invokeFunction("specialQuery", itemsWrapper, fieldProperties.getDictQuery());
                items = itemsWrapper.getItems();
            }
            catch (ScriptException e) {
                ExceptionUtils.logSevereException((Exception)e);
                NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)"invoker.form.special_data_query_code.script_exception", (Exception)e);
                throw new BuildingFailedException(this, null);
            }
            catch (NoSuchMethodException e) {
                ExceptionUtils.logSevereException((Exception)e);
                NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)"invoker.form.special_data_query_code.no_such_method_exception", (Exception)e);
                throw new BuildingFailedException(this, null);
            }
        }
        return items;
    }

    private FilterContainer getFilterContainer(String filterId) {
        if (this.filters == null) {
            this.filters = new HashMap();
        }
        if (!this.filters.containsKey(filterId)) {
            this.filters.put(filterId, new FilterContainer());
        }
        return (FilterContainer)this.filters.get(filterId);
    }

    private String getValueFromMap(Map<ReportConstants.Keys, ReportProperty> props, ReportConstants.Keys key, Enum<?>[] inputTypes, String defaultValue) {
        if (props.containsKey(key)) {
            String value = props.get(key).getValue();
            if (inputTypes == null) {
                return value;
            }
            value = StringUtils.upperCase((String)value);
            for (Enum<?> enum1 : inputTypes) {
                if (!enum1.name().equals(value)) continue;
                return value;
            }
        }
        return defaultValue;
    }

    private void init() {
        this.setCompositionRoot((Component)this.form);
        this.form.setReadOnly(this.readonly);
    }

    private void initFieldsFromConfig() {
        if (this.reportParameters != null && !this.reportParameters.isEmpty()) {
            block2: for (ReportConfigParameter p : this.reportParameters) {
                for (FieldContainer field : this.fields) {
                    if (!p.getName().equals(field.getName())) continue;
                    try {
                        Class fieldType;
                        Field fieldComponent;
                        Field field2 = fieldComponent = field.getFieldComponent() instanceof Field ? (Field)field.getFieldComponent() : null;
                        Class<Date> clazz = fieldComponent == null ? null : (fieldType = fieldComponent.getPropertyDataSource() == null ? null : fieldComponent.getPropertyDataSource().getType());
                        if (ReportConstants.InputTypes.DATE.equals((Object)field.getComponentType())) {
                            fieldType = Date.class;
                        } else if (ReportConstants.InputTypes.MULTISELECT.equals((Object)field.getComponentType()) || ReportConstants.InputTypes.CHECKBOXES.equals((Object)field.getComponentType()) || ReportConstants.InputTypes.FILTERED_SELECT.equals((Object)field.getComponentType())) {
                            fieldType = Collection.class;
                        }
                        Object v = TextUtils.encodeSQLToObject(fieldType, (String)p.getValue());
                        field.setValue(v);
                        continue block2;
                    }
                    catch (ParseException e) {
                        ExceptionUtils.logSevereException((Exception)e);
                        NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)VaadinUtil.getValue((String)"exception.gui.error"), (Exception)e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    private void initView() {
        List parameters = this.reportMaster.getParameters();
        for (ReportParameter param : parameters) {
            Map props = param.getProperties();
            if (props == null || props.isEmpty()) continue;
            FieldProperties fieldProperties = this.parseFieldProperties(param, props);
            FieldContainer container = this.buildField(param, fieldProperties);
            this.fields.add(container);
        }
        Collections.sort(this.fields, new /* Unavailable Anonymous Inner Class!! */);
        FormLayout layout = new FormLayout();
        this.form.setLayout((Layout)layout);
        for (FieldContainer field : this.fields) {
            if (field == null) continue;
            field.placeYourselfInForm(this.form, layout);
        }
        if (this.includeReportFormat) {
            this.format = ComponentFactory.createFormatCombo((ReportConstants.ReportType)ReportConstants.ReportType.PDF, (String)"invoker.form.select_format");
            this.form.addField((Object)"format", (Field)this.format);
        }
        if (this.fields.isEmpty()) {
            Label l = new Label(VaadinUtil.getValue((String)"invoker.form.header.nofields"));
            l.setWidth("400px");
            this.form.getLayout().addComponent((Component)l);
        } else {
            this.form.setDescription(this.readonly ? VaadinUtil.getValue((String)"invoker.form.header.readonly") : VaadinUtil.getValue((String)"invoker.form.header"));
        }
        this.form.setImmediate(true);
        this.form.setValidationVisible(true);
        this.form.setValidationVisibleOnCommit(true);
        this.form.setInvalidCommitted(false);
        this.form.setWriteThrough(false);
    }

    private FieldProperties parseFieldProperties(ReportParameter param, Map<ReportConstants.Keys, ReportProperty> props) {
        FieldProperties fieldProperties = new FieldProperties();
        String inputTypeString = this.getValueFromMap(props, ReportConstants.Keys.INPUT_TYPE, (Enum[])ReportConstants.InputTypes.values(), ReportConstants.InputTypes.CHECKBOX.name());
        fieldProperties.setInputType(ReportConstants.InputTypes.valueOf((String)StringUtils.upperCase((String)inputTypeString)));
        fieldProperties.setWidth(this.getValueFromMap(props, ReportConstants.Keys.WIDTH, null, ""));
        String caption = this.getValueFromMap(props, ReportConstants.Keys.LABEL, null, param.getName());
        fieldProperties.setCaption(StringUtils.capitaliseAllWords((String)StringUtils.lowerCase((String)caption)));
        String orderString = this.getValueFromMap(props, ReportConstants.Keys.ORDER, null, "1000");
        try {
            fieldProperties.setOrder(Integer.valueOf(orderString));
        }
        catch (NumberFormatException e) {
            fieldProperties.setOrder(Integer.valueOf(1000));
        }
        String requiredString = this.getValueFromMap(props, ReportConstants.Keys.REQUIRED, (Enum[])ReportConstants.BooleanValues.values(), "false");
        fieldProperties.setRequired(Boolean.valueOf(requiredString));
        fieldProperties.setRequiredError(this.getValueFromMap(props, ReportConstants.Keys.REQUIRED_ERROR, null, "form.errors.required"));
        fieldProperties.setRegexp(this.getValueFromMap(props, ReportConstants.Keys.REGEXP, null, ""));
        fieldProperties.setRegexpError(this.getValueFromMap(props, ReportConstants.Keys.REGEXP_ERROR, null, "form.errors.regexp"));
        fieldProperties.setMaxchars(this.getValueFromMap(props, ReportConstants.Keys.MAXCHARS, null, ""));
        String levelString = this.getValueFromMap(props, ReportConstants.Keys.LEVEL, null, "1");
        try {
            fieldProperties.setLevel(Integer.valueOf(levelString));
        }
        catch (NumberFormatException e) {
            fieldProperties.setOrder(Integer.valueOf(1));
        }
        fieldProperties.setFilterGroup(this.getValueFromMap(props, ReportConstants.Keys.FILTER_GROUP, null, ""));
        String selectAllString = this.getValueFromMap(props, ReportConstants.Keys.SELECT_ALL, (Enum[])ReportConstants.BooleanValues.values(), "false");
        fieldProperties.setSelectAll(Boolean.valueOf(selectAllString));
        String multipleChoiceString = this.getValueFromMap(props, ReportConstants.Keys.MULTIPLE_CHOICE, (Enum[])ReportConstants.BooleanValues.values(), "false");
        fieldProperties.setMultipleChoice(Boolean.valueOf(multipleChoiceString));
        fieldProperties.setDictQuery(this.getValueFromMap(props, ReportConstants.Keys.DICT_QUERY, null, ""));
        fieldProperties.setDictItemList(this.getValueFromMap(props, ReportConstants.Keys.DICT_ITEM_LIST, null, ""));
        String scriptLang = this.getValueFromMap(props, ReportConstants.Keys.SCRIPT_LANGUAGE, null, "");
        if (StringUtils.isNotEmpty((String)scriptLang)) {
            ScriptEngine se;
            ScriptEngineManager sem = new ScriptEngineManager();
            try {
                se = sem.getEngineByName(scriptLang);
            }
            catch (NoSuchMethodError e) {
                try {
                    se = sem.getEngineByName(scriptLang);
                }
                catch (NoSuchMethodError e1) {
                    try {
                        se = sem.getEngineByName(scriptLang);
                    }
                    catch (NoSuchMethodError e2) {
                        se = sem.getEngineByName(scriptLang);
                    }
                }
            }
            Invocable sei = (Invocable)((Object)se);
            fieldProperties.setSei(sei);
            fieldProperties.setSe(se);
        }
        fieldProperties.setSpecialControlCode(this.getValueFromMap(props, ReportConstants.Keys.SPECIAL_CONTROL_CODE, null, ""));
        fieldProperties.setSpecialValidationCode(this.getValueFromMap(props, ReportConstants.Keys.SPECIAL_VALIDATION_CODE, null, ""));
        fieldProperties.setSpecialValidationError(this.getValueFromMap(props, ReportConstants.Keys.SPECIAL_VALIDATION_ERROR, null, ""));
        fieldProperties.setSpecialDataQueryCode(this.getValueFromMap(props, ReportConstants.Keys.SPECIAL_DATA_QUERY_CODE, null, ""));
        return fieldProperties;
    }

    public void attach() {
        super.attach();
        this.initView();
        this.initFieldsFromConfig();
    }
}

