/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.dashboard;

import com.vaadin.ui.CustomComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import org.apache.commons.codec.binary.Base64;
import org.apertereports.common.exception.AperteReportsRuntimeException;
import org.apertereports.common.xml.config.ReportConfig;
import org.apertereports.common.xml.config.XmlReportConfigLoader;
import org.apertereports.util.cache.MapCache;

public abstract class AbstractDashboardComponent
extends CustomComponent {
    protected List<ReportConfig> reportConfigs;
    protected String template;
    protected PortletPreferences preferences;
    protected PortletSession session;
    protected String portletId;
    protected MapCache cache = new MapCache();

    protected void prepareData() {
        if (this.preferences != null) {
            this.template = this.preferences.getValue("template", null);
            this.template = this.template != null ? new String(Base64.decodeBase64((byte[])this.template.getBytes())) : null;
            String rc = this.preferences.getValue("reportConfigs", null);
            if (rc != null) {
                rc = new String(Base64.decodeBase64((byte[])rc.getBytes()));
                this.reportConfigs = XmlReportConfigLoader.getInstance().stringAsReportConfigs(rc);
                Collections.sort(this.reportConfigs, new /* Unavailable Anonymous Inner Class!! */);
            } else {
                this.reportConfigs = new ArrayList();
            }
        }
    }

    protected void saveData() {
        if (this.preferences != null) {
            try {
                this.template = this.template != null ? new String(Base64.encodeBase64((byte[])this.template.getBytes())) : null;
                this.preferences.setValue("template", this.template);
                if (this.reportConfigs != null) {
                    for (ReportConfig rc : this.reportConfigs) {
                        if (rc.getCyclicReportId() == null) continue;
                        rc.setParameters(null);
                    }
                }
                String rc = XmlReportConfigLoader.getInstance().reportConfigsAsString(this.reportConfigs);
                rc = new String(Base64.encodeBase64((byte[])rc.getBytes()));
                this.preferences.setValue("reportConfigs", rc);
                this.preferences.store();
            }
            catch (Exception e) {
                throw new AperteReportsRuntimeException(e);
            }
        }
    }

    public void initData() {
        this.prepareData();
        this.initComponentData();
    }

    protected abstract void initComponentData();

    public void setPortletPreferences(PortletPreferences preferences) {
        this.preferences = preferences;
    }

    public void setPortletSession(PortletSession session) {
        this.session = session;
    }

    public void setPortletId(String portletId) {
        this.portletId = portletId;
    }
}

